"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiFormControlLayoutDelimited", {
  enumerable: true,
  get: function get() {
    return _form_control_layout_delimited.EuiFormControlLayoutDelimited;
  }
});
exports.OuiFormControlLayoutDelimited = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _text = require("../../text");

var _form_control_layout = require("./form_control_layout");

var _form_control_layout_delimited = require("../../../eui_components/form/form_control_layout/form_control_layout_delimited");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var OuiFormControlLayoutDelimited = function OuiFormControlLayoutDelimited(_ref) {
  var startControl = _ref.startControl,
      endControl = _ref.endControl,
      _ref$delimiter = _ref.delimiter,
      delimiter = _ref$delimiter === void 0 ? '→' : _ref$delimiter,
      className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["startControl", "endControl", "delimiter", "className"]);
  var classes = (0, _classnames.default)('ouiFormControlLayoutDelimited', className);
  return /*#__PURE__*/_react.default.createElement(_form_control_layout.OuiFormControlLayout, (0, _extends2.default)({
    className: classes
  }, rest), addClassesToControl(startControl), /*#__PURE__*/_react.default.createElement(_text.OuiText, {
    className: "ouiFormControlLayoutDelimited__delimeter",
    size: "s",
    color: "subdued"
  }, delimiter), addClassesToControl(endControl));
};

exports.OuiFormControlLayoutDelimited = OuiFormControlLayoutDelimited;
OuiFormControlLayoutDelimited.propTypes = {
  /**
     * Left side control
     */
  startControl: _propTypes.default.element.isRequired,

  /**
     * Right side control
     */
  endControl: _propTypes.default.element.isRequired,

  /**
     * The center content. Accepts a string to be wrapped in a subdued OuiText
     * or a single ReactElement
     */
  delimiter: _propTypes.default.node,
  className: _propTypes.default.string
};

function addClassesToControl(control) {
  return /*#__PURE__*/(0, _react.cloneElement)(control, {
    className: (0, _classnames.default)(control.props.className, 'ouiFormControlLayoutDelimited__input')
  });
}
/* OUI -> EUI Aliases: Build-Time */

/* OUI -> EUI Aliases: Build-Time */