/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.api.beans.LocalizedExternalFile;
import com.install4j.api.beans.ReplacementMode;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.components.TextSource;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.HtmlTextHelper;
import com.install4j.runtime.util.HtmlTextPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class HtmlDisplay
extends JPanel {
    private HtmlTextProvider htmlTextProvider;
    private HtmlTextPane.CaretTarget caretTarget;
    private HtmlTextPane htmlTextPane;
    private JScrollPane scpInfo;
    private String actualText;
    private boolean allRead = false;
    private Context context;

    public HtmlDisplay(HtmlTextProvider htmlTextProvider, HtmlTextPane.CaretTarget caretTarget) {
        this.htmlTextProvider = htmlTextProvider;
        this.caretTarget = caretTarget;
        this.setupControls();
        this.setupEventHandlers();
        this.setupComponent();
    }

    public void setPreferredHeight(int preferredHeight) {
        this.scpInfo.setPreferredSize(new Dimension(100, preferredHeight));
    }

    public String getActualText() {
        return this.actualText;
    }

    public boolean isAllRead() {
        return this.allRead;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public HtmlTextPane getHtmlTextPane() {
        return this.htmlTextPane;
    }

    private void setupControls() {
        this.htmlTextPane = new HtmlTextPane(this.caretTarget);
        this.scpInfo = new JScrollPane(this.htmlTextPane);
        this.scpInfo.getViewport().setBackground(Color.WHITE);
    }

    private void setupEventHandlers() {
        this.scpInfo.getVerticalScrollBar().addAdjustmentListener(e -> this.checkAllRead());
    }

    private void setupComponent() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.scpInfo, "Center");
    }

    private void checkAllRead() {
        JScrollBar scrollBar = this.scpInfo.getVerticalScrollBar();
        if (this.isShowing() && scrollBar.getValue() + scrollBar.getModel().getExtent() == scrollBar.getMaximum()) {
            this.allRead = true;
        }
    }

    public void handleConsole(Console console) throws UserCanceledException {
        String originalText = HtmlTextHelper.formatTextWithoutHtmlTags(this.getOrLoadText());
        console.println();
        console.more(originalText);
        console.println();
        this.actualText = originalText;
    }

    public void updateText() {
        String newText = this.getOrLoadText();
        if (!Objects.equals(newText, this.actualText)) {
            this.actualText = newText;
            this.htmlTextPane.updateText(this.actualText);
            this.allRead = false;
            this.checkAllRead();
        }
    }

    private String getOrLoadText() {
        String originalText;
        if (this.htmlTextProvider.getTextSource() == TextSource.FILE) {
            originalText = InstallerUtil.loadFile(this.context.getExternalFile(this.htmlTextProvider.getDisplayedTextFile(), false), this.context.getLanguageId());
            if (originalText == null) {
                originalText = "";
            }
        } else {
            originalText = this.htmlTextProvider.getRawDisplayedText();
        }
        this.htmlTextProvider.getFormEnvironment().bindTextWithVariables(originalText, this.getHtmlTextPane());
        return InstallerVariables.replaceVariables(originalText, ReplacementMode.PLAIN, VariableErrorHandlingDescriptor.ALWAYS_IGNORE);
    }

    public static interface HtmlTextProvider {
        public TextSource getTextSource();

        public LocalizedExternalFile getDisplayedTextFile();

        public String getRawDisplayedText();

        public FormEnvironment getFormEnvironment();
    }
}

