/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.tools.plugin.edit;

import java.awt.Color;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.TextProperties;
import org.gephi.graph.api.TimeFormat;
import org.gephi.ui.tools.plugin.edit.EditWindowUtils;
import org.gephi.ui.tools.plugin.edit.MultipleRowsAttributeValueWrapper;
import org.gephi.ui.tools.plugin.edit.SingleRowAttributeValueWrapper;
import org.joda.time.DateTimeZone;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EditEdges
extends AbstractNode {
    private final Edge[] edges;
    private final boolean multipleEdges;
    private final TimeFormat currentTimeFormat;
    private final DateTimeZone dateTimeZone;
    private Node.PropertySet[] propertySets;

    public EditEdges(Edge edge) {
        super(Children.LEAF);
        this.edges = new Edge[]{edge};
        this.setName(edge.getLabel());
        this.multipleEdges = false;
        GraphController gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        this.currentTimeFormat = gc.getGraphModel().getTimeFormat();
        this.dateTimeZone = gc.getGraphModel().getTimeZone();
    }

    public EditEdges(Edge[] edges) {
        super(Children.LEAF);
        this.edges = edges;
        boolean bl = this.multipleEdges = edges.length > 1;
        if (this.multipleEdges) {
            this.setName(NbBundle.getMessage(EditEdges.class, (String)"EditEdges.multiple.elements"));
        } else {
            this.setName(edges[0].getLabel());
        }
        GraphController gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        this.currentTimeFormat = gc.getGraphModel().getTimeFormat();
        this.dateTimeZone = gc.getGraphModel().getTimeZone();
    }

    public Node.PropertySet[] getPropertySets() {
        this.propertySets = new Node.PropertySet[]{this.prepareEdgesProperties(), this.prepareEdgesAttributes()};
        return this.propertySets;
    }

    private Sheet.Set prepareEdgesAttributes() {
        try {
            AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
            Sheet.Set set = new Sheet.Set();
            set.setName("attributes");
            if (this.edges.length > 1) {
                set.setDisplayName(NbBundle.getMessage(EditEdges.class, (String)"EditEdges.attributes.text.multiple"));
            } else {
                set.setDisplayName(NbBundle.getMessage(EditEdges.class, (String)"EditEdges.attributes.text", (Object)this.edges[0].getLabel()));
            }
            Edge row = this.edges[0];
            for (Column column : row.getAttributeColumns()) {
                EditWindowUtils.AttributeValueWrapper wrap = this.multipleEdges ? new MultipleRowsAttributeValueWrapper((Element[])this.edges, column, this.currentTimeFormat, this.dateTimeZone) : new SingleRowAttributeValueWrapper((Element)this.edges[0], column, this.currentTimeFormat, this.dateTimeZone);
                Class type = column.getTypeClass();
                PropertyEditor propEditor = PropertyEditorManager.findEditor(type);
                PropertySupport.Reflection p = ac.canChangeColumnData(column) ? (propEditor != null && !type.isArray() ? new PropertySupport.Reflection((Object)wrap, type, "getValue" + type.getSimpleName(), "setValue" + type.getSimpleName()) : new PropertySupport.Reflection((Object)wrap, String.class, "getValueAsString", "setValueAsString")) : (propEditor != null ? new PropertySupport.Reflection((Object)wrap, type, "getValue" + type.getSimpleName(), null) : new PropertySupport.Reflection((Object)wrap, String.class, "getValueAsString", null));
                p.setDisplayName(column.getTitle());
                p.setName(column.getId());
                set.put((Node.Property)p);
            }
            return set;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private Sheet.Set prepareEdgesProperties() {
        try {
            if (this.multipleEdges) {
                Sheet.Set set = new Sheet.Set();
                set.setName("properties");
                set.setDisplayName(NbBundle.getMessage(EditEdges.class, (String)"EditEdges.properties.text.multiple"));
                MultipleEdgesPropertiesWrapper edgesWrapper = new MultipleEdgesPropertiesWrapper(this.edges);
                PropertySupport.Reflection p = new PropertySupport.Reflection((Object)edgesWrapper, Color.class, "getEdgesColor", "setEdgesColor");
                p.setDisplayName(NbBundle.getMessage(EditEdges.class, (String)"EditEdges.color.text"));
                p.setName("color");
                set.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)edgesWrapper, Color.class, "getLabelsColor", "setLabelsColor");
                p.setDisplayName(NbBundle.getMessage(EditEdges.class, (String)"EditEdges.label.color.text"));
                p.setName("labelcolor");
                set.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)edgesWrapper, Float.class, "getLabelsSize", "setLabelsSize");
                p.setDisplayName(NbBundle.getMessage(EditEdges.class, (String)"EditEdges.label.size.text"));
                p.setName("labelsize");
                set.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)edgesWrapper, Boolean.class, "getLabelsVisible", "setLabelsVisible");
                p.setDisplayName(NbBundle.getMessage(EditEdges.class, (String)"EditEdges.label.visible.text"));
                p.setName("labelvisible");
                set.put((Node.Property)p);
                return set;
            }
            Edge edge = this.edges[0];
            Sheet.Set set = new Sheet.Set();
            set.setName("properties");
            set.setDisplayName(NbBundle.getMessage(EditEdges.class, (String)"EditEdges.properties.text", (Object)edge.getLabel()));
            SingleEdgePropertiesWrapper edgeWrapper = new SingleEdgePropertiesWrapper(edge);
            PropertySupport.Reflection p = new PropertySupport.Reflection((Object)edgeWrapper, Color.class, "getEdgeColor", "setEdgeColor");
            p.setDisplayName(NbBundle.getMessage(EditEdges.class, (String)"EditEdges.color.text"));
            p.setName("color");
            set.put((Node.Property)p);
            TextProperties textProperties = edge.getTextProperties();
            p = new PropertySupport.Reflection((Object)textProperties, Float.TYPE, "getSize", "setSize");
            p.setDisplayName(NbBundle.getMessage(EditEdges.class, (String)"EditEdges.label.size.text"));
            p.setName("labelsize");
            set.put((Node.Property)p);
            p = new PropertySupport.Reflection((Object)edgeWrapper, Color.class, "getLabelColor", "setLabelColor");
            p.setDisplayName(NbBundle.getMessage(EditEdges.class, (String)"EditEdges.label.color.text"));
            p.setName("labelcolor");
            set.put((Node.Property)p);
            p = new PropertySupport.Reflection((Object)textProperties, Boolean.TYPE, "isVisible", "setVisible");
            p.setDisplayName(NbBundle.getMessage(EditEdges.class, (String)"EditEdges.label.visible.text"));
            p.setName("labelvisible");
            set.put((Node.Property)p);
            return set;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public class MultipleEdgesPropertiesWrapper {
        Edge[] edges;
        private Color edgesColor = null;
        private Color labelsColor = null;
        private Float labelsSize = null;
        private Boolean labelsVisible = null;

        public MultipleEdgesPropertiesWrapper(Edge[] Edges) {
            this.edges = Edges;
        }

        public Color getEdgesColor() {
            return this.edgesColor;
        }

        public void setEdgesColor(Color c) {
            if (c != null) {
                this.edgesColor = c;
                for (Edge edge : this.edges) {
                    edge.setR((float)c.getRed() / 255.0f);
                    edge.setG((float)c.getGreen() / 255.0f);
                    edge.setB((float)c.getBlue() / 255.0f);
                    edge.setAlpha((float)c.getAlpha() / 255.0f);
                }
            }
        }

        public Color getLabelsColor() {
            return this.labelsColor;
        }

        public void setLabelsColor(Color c) {
            if (c != null) {
                this.labelsColor = c;
                for (Edge edge : this.edges) {
                    TextProperties textProps = edge.getTextProperties();
                    textProps.setR((float)c.getRed() / 255.0f);
                    textProps.setG((float)c.getGreen() / 255.0f);
                    textProps.setB((float)c.getBlue() / 255.0f);
                    textProps.setAlpha((float)c.getAlpha() / 255.0f);
                }
            }
        }

        public Float getLabelsSize() {
            return this.labelsSize;
        }

        public void setLabelsSize(Float size) {
            this.labelsSize = size;
            for (Edge edge : this.edges) {
                TextProperties textProps = edge.getTextProperties();
                textProps.setSize(size.floatValue());
            }
        }

        public Boolean getLabelsVisible() {
            return this.labelsVisible;
        }

        public void setLabelsVisible(Boolean visible) {
            this.labelsVisible = visible;
            for (Edge edge : this.edges) {
                TextProperties textProps = edge.getTextProperties();
                textProps.setVisible(visible.booleanValue());
            }
        }
    }

    public class SingleEdgePropertiesWrapper {
        private final Edge edge;

        public SingleEdgePropertiesWrapper(Edge Edge2) {
            this.edge = Edge2;
        }

        public Color getEdgeColor() {
            if (this.edge.alpha() == 0.0f) {
                return null;
            }
            return new Color(this.edge.r(), this.edge.g(), this.edge.b(), this.edge.alpha());
        }

        public void setEdgeColor(Color c) {
            if (c != null) {
                this.edge.setR((float)c.getRed() / 255.0f);
                this.edge.setG((float)c.getGreen() / 255.0f);
                this.edge.setB((float)c.getBlue() / 255.0f);
                this.edge.setAlpha((float)c.getAlpha() / 255.0f);
            }
        }

        public Color getLabelColor() {
            TextProperties textProps = this.edge.getTextProperties();
            if (textProps.getAlpha() == 0.0f) {
                return null;
            }
            return textProps.getColor();
        }

        public void setLabelColor(Color c) {
            if (c != null) {
                TextProperties textProps = this.edge.getTextProperties();
                textProps.setColor(c);
            }
        }
    }
}

