/**
 * SECTION:backend
 * @short_description: A single backend to libfolks, such as Telepathy or evolution-data-server. Each backend provides <link linkend="FolksPersona"><type>FolksPersona</type></link>s which are aggregated to form <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.
 * 
 * <para>After creating a Backend instance, you must connect to the <link linkend="FolksBackend-persona-store-added"><type>"persona-store-added"</type></link> and <link linkend="FolksBackend-persona-store-removed"><type>"persona-store-removed"</type></link> signals, <emphasis>then</emphasis> call <link linkend="folks-backend-prepare"><function>folks_backend_prepare()</function></link>, otherwise a race condition may occur between emission of <link linkend="FolksBackend-persona-store-added"><type>"persona-store-added"</type></link> and your code connecting to it.</para>
 */
/**
 * FOLKS_TYPE_BACKEND:
 * 
 * The type for <link linkend="FolksBackend"><type>FolksBackend</type></link>.
 */
/**
 * folks_backend_disable_persona_store:
 * @self: the <link linkend="FolksBackend"><type>FolksBackend</type></link> instance
 * @store: (in): &nbsp;.  <para>the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> to disable. </para>
 * 
 * Disable a <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.
 * 
 * <para>If the given persona store is in this backend <link linkend="FolksBackend--persona-stores"><type>"persona-stores"</type></link>, it will be removed, and we will disconnect from its signals.</para>
 *
 * Since: 0.9.0
 */
/**
 * folks_backend_enable_persona_store:
 * @self: the <link linkend="FolksBackend"><type>FolksBackend</type></link> instance
 * @store: (in): &nbsp;.  <para>the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> to enable. </para>
 * 
 * Enable a <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>.
 * 
 * <para>If the given persona store is not already in this backend <link linkend="FolksBackend--persona-stores"><type>"persona-stores"</type></link>, it will be added to the backend and <link linkend="FolksBackend--persona-stores"><type>"persona-stores"</type></link> property notification will be emitted, along with <link linkend="FolksBackend-persona-store-added"><type>"persona-store-added"</type></link>.</para>
 *
 * Since: 0.9.0
 */
/**
 * folks_backend_set_persona_stores:
 * @self: the <link linkend="FolksBackend"><type>FolksBackend</type></link> instance
 * @storeids: (in) (allow-none): &nbsp;.  <para>a Set of <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> IDs to use. </para>
 * 
 * Set the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s to use in this backend.
 * 
 * <para>This will cause <link linkend="FolksBackend-persona-store-removed"><type>"persona-store-removed"</type></link> signals to be emitted for all removed stores, followed by <link linkend="FolksBackend-persona-store-added"><type>"persona-store-added"</type></link> signals for all added stores. As these signals are emitted, the sets of individuals in any associated <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link>s will be updated, and <link linkend="FolksIndividualAggregator-individuals-changed"><type>"individuals-changed"</type></link> may be emitted multiple times as appropriate. A property change notification for <link linkend="FolksBackend--persona-stores"><type>"persona-stores"</type></link> will be emitted last. Note: pass null storeids to use all available persona stores.</para>
 *
 * Since: 0.9.0
 */
/**
 * folks_backend_prepare:
 * @self: the <link linkend="FolksBackend"><type>FolksBackend</type></link> instance
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Prepare the Backend for use.
 * 
 * <para>This connects the Backend to whichever backend-specific services it requires, and causes it to create its <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s. This should be called <emphasis>after</emphasis> connecting to the <link linkend="FolksBackend-persona-store-added"><type>"persona-store-added"</type></link> and <link linkend="FolksBackend-persona-store-removed"><type>"persona-store-removed"</type></link> signals, or a race condition could occur, with the signals being emitted before your code has connected to them, and <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s getting &quot;lost&quot; as a result.</para><para>This is normally handled transparently by the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link>.</para><para>If this function throws an error, the Backend will not be functional.</para><para>This function is guaranteed to be idempotent (since version 0.3.0).</para><para>Concurrent calls to this function from different threads will block until preparation has completed. However, concurrent calls to this function from a single thread might not, i.e. the first call will block but subsequent calls might return before the first one. (Though they will be safe in every other respect.)</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if preparing the backend-specific services failed — this will be a backend-specific error </para></para>
 * <para><link linkend="G-DBUS-ERROR-SERVICE-UNKNOWN:CAPS"><literal>G_DBUS_ERROR_SERVICE_UNKNOWN</literal></link> will be returned in @error <para>if a required D-Bus service was not installed or could not be started </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-backend-prepare-finish"><function>folks_backend_prepare_finish()</function></link>
 *
 * Since: 0.1.11
 */
/**
 * folks_backend_prepare_finish:
 * @self: the <link linkend="FolksBackend"><type>FolksBackend</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Prepare the Backend for use.
 * 
 * <para>This connects the Backend to whichever backend-specific services it requires, and causes it to create its <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s. This should be called <emphasis>after</emphasis> connecting to the <link linkend="FolksBackend-persona-store-added"><type>"persona-store-added"</type></link> and <link linkend="FolksBackend-persona-store-removed"><type>"persona-store-removed"</type></link> signals, or a race condition could occur, with the signals being emitted before your code has connected to them, and <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s getting &quot;lost&quot; as a result.</para><para>This is normally handled transparently by the <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link>.</para><para>If this function throws an error, the Backend will not be functional.</para><para>This function is guaranteed to be idempotent (since version 0.3.0).</para><para>Concurrent calls to this function from different threads will block until preparation has completed. However, concurrent calls to this function from a single thread might not, i.e. the first call will block but subsequent calls might return before the first one. (Though they will be safe in every other respect.)</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if preparing the backend-specific services failed — this will be a backend-specific error </para></para>
 * <para><link linkend="G-DBUS-ERROR-SERVICE-UNKNOWN:CAPS"><literal>G_DBUS_ERROR_SERVICE_UNKNOWN</literal></link> will be returned in @error <para>if a required D-Bus service was not installed or could not be started </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-backend-prepare"><function>folks_backend_prepare()</function></link>
 *
 * Since: 0.1.11
 */
/**
 * folks_backend_unprepare:
 * @self: the <link linkend="FolksBackend"><type>FolksBackend</type></link> instance
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Revert the Backend to its pre-prepared state.
 * 
 * <para>This will disconnect this Backend and its dependencies from their respective services and the Backend will issue <link linkend="FolksBackend-persona-store-removed"><type>"persona-store-removed"</type></link> for each of its <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s.</para><para>Most users won&apos;t need to use this function.</para><para>If this function throws an error, the Backend will not be functional.</para><para>Concurrent calls to this function from different threads will block until preparation has completed. However, concurrent calls to this function from a single thread might not, i.e. the first call will block but subsequent calls might return before the first one. (Though they will be safe in every other respect.)</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if unpreparing the backend-specific services failed — this will be a backend-specific error </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-backend-unprepare-finish"><function>folks_backend_unprepare_finish()</function></link>
 *
 * Since: 0.3.2
 */
/**
 * folks_backend_unprepare_finish:
 * @self: the <link linkend="FolksBackend"><type>FolksBackend</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Revert the Backend to its pre-prepared state.
 * 
 * <para>This will disconnect this Backend and its dependencies from their respective services and the Backend will issue <link linkend="FolksBackend-persona-store-removed"><type>"persona-store-removed"</type></link> for each of its <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s.</para><para>Most users won&apos;t need to use this function.</para><para>If this function throws an error, the Backend will not be functional.</para><para>Concurrent calls to this function from different threads will block until preparation has completed. However, concurrent calls to this function from a single thread might not, i.e. the first call will block but subsequent calls might return before the first one. (Though they will be safe in every other respect.)</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if unpreparing the backend-specific services failed — this will be a backend-specific error </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-backend-unprepare"><function>folks_backend_unprepare()</function></link>
 *
 * Since: 0.3.2
 */
/**
 * FolksBackend:is-prepared:
 * 
 * Whether <link linkend="folks-backend-prepare"><function>folks_backend_prepare()</function></link> has successfully completed for this backend.
 *
 * Since: 0.3.0
 */
/**
 * folks_backend_get_is_prepared:
 * @self: the <link linkend="FolksBackend"><type>FolksBackend</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksBackend--is-prepared"><type>"is-prepared"</type></link> property.
 * 
 * Whether <link linkend="folks-backend-prepare"><function>folks_backend_prepare()</function></link> has successfully completed for this backend.
 * 
 * Returns: the value of the <link linkend="FolksBackend--is-prepared"><type>"is-prepared"</type></link> property
 *
 * Since: 0.3.0
 */
/**
 * FolksBackend:is-quiescent:
 * 
 * Whether the backend has reached a quiescent state. This will happen at some point after <link linkend="folks-backend-prepare"><function>folks_backend_prepare()</function></link> has successfully completed for the backend. A backend is in a quiescent state when all the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s that it originally knows about have been loaded.
 * 
 * <para>It&apos;s guaranteed that this property&apos;s value will only ever change after <link linkend="FolksBackend--is-prepared"><type>"is-prepared"</type></link> has changed to <code>true</code>.</para><para>When <link linkend="folks-backend-unprepare"><function>folks_backend_unprepare()</function></link> is called, this will be reset to <code>false</code>.</para>
 *
 * Since: 0.6.2
 */
/**
 * folks_backend_get_is_quiescent:
 * @self: the <link linkend="FolksBackend"><type>FolksBackend</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksBackend--is-quiescent"><type>"is-quiescent"</type></link> property.
 * 
 * Whether the backend has reached a quiescent state. This will happen at some point after <link linkend="folks-backend-prepare"><function>folks_backend_prepare()</function></link> has successfully completed for the backend. A backend is in a quiescent state when all the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s that it originally knows about have been loaded.
 * 
 * <para>It&apos;s guaranteed that this property&apos;s value will only ever change after <link linkend="FolksBackend--is-prepared"><type>"is-prepared"</type></link> has changed to <code>true</code>.</para><para>When <link linkend="folks-backend-unprepare"><function>folks_backend_unprepare()</function></link> is called, this will be reset to <code>false</code>.</para>
 * 
 * Returns: the value of the <link linkend="FolksBackend--is-quiescent"><type>"is-quiescent"</type></link> property
 *
 * Since: 0.6.2
 */
/**
 * FolksBackend:name:
 * 
 * A unique name for the backend.
 * 
 * <para>This will be used to identify the backend, and should also be used as the <link linkend="FolksPersonaStore--type-id"><type>"type-id"</type></link> of the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s used by the backend.</para><para>This is guaranteed to always be available; even before <link linkend="folks-backend-prepare"><function>folks_backend_prepare()</function></link> is called.</para>
 */
/**
 * folks_backend_get_name:
 * @self: the <link linkend="FolksBackend"><type>FolksBackend</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksBackend--name"><type>"name"</type></link> property.
 * 
 * A unique name for the backend.
 * 
 * <para>This will be used to identify the backend, and should also be used as the <link linkend="FolksPersonaStore--type-id"><type>"type-id"</type></link> of the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s used by the backend.</para><para>This is guaranteed to always be available; even before <link linkend="folks-backend-prepare"><function>folks_backend_prepare()</function></link> is called.</para>
 * 
 * Returns: the value of the <link linkend="FolksBackend--name"><type>"name"</type></link> property
 */
/**
 * FolksBackend:persona-stores:
 * 
 * The <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s in use by the backend.
 * 
 * <para>A backend may expose <link linkend="FolksPersona"><type>FolksPersona</type></link>s from multiple servers or accounts (for example), so may have a <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> for each.</para>
 *
 * Since: 0.5.1
 */
/**
 * folks_backend_get_persona_stores:
 * @self: the <link linkend="FolksBackend"><type>FolksBackend</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksBackend--persona-stores"><type>"persona-stores"</type></link> property.
 * 
 * The <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link>s in use by the backend.
 * 
 * <para>A backend may expose <link linkend="FolksPersona"><type>FolksPersona</type></link>s from multiple servers or accounts (for example), so may have a <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> for each.</para>
 * 
 * Returns: the value of the <link linkend="FolksBackend--persona-stores"><type>"persona-stores"</type></link> property
 *
 * Since: 0.5.1
 */
/**
 * FolksBackend::persona-store-added:
 * @backend: the <link linkend="FolksBackend"><type>FolksBackend</type></link> instance that received the signal
 * @store: &nbsp;.  <para>the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> </para><para></para>
 * 
 * Emitted when a <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> is added to the backend.
 * 
 * <para>This will not be emitted until after <link linkend="folks-backend-prepare"><function>folks_backend_prepare()</function></link> has been called.</para>
 */
/**
 * FolksBackend::persona-store-removed:
 * @backend: the <link linkend="FolksBackend"><type>FolksBackend</type></link> instance that received the signal
 * @store: &nbsp;.  <para>the <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> </para><para></para>
 * 
 * Emitted when a <link linkend="FolksPersonaStore"><type>FolksPersonaStore</type></link> is removed from the backend.
 * 
 * <para>This will not be emitted until after <link linkend="folks-backend-prepare"><function>folks_backend_prepare()</function></link> has been called.</para>
 */
/**
 * FolksBackend:
 * 
 * A single backend to libfolks, such as Telepathy or evolution-data-server. Each backend provides <link linkend="FolksPersona"><type>FolksPersona</type></link>s which are aggregated to form <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.
 * 
 * <para>After creating a Backend instance, you must connect to the <link linkend="FolksBackend-persona-store-added"><type>"persona-store-added"</type></link> and <link linkend="FolksBackend-persona-store-removed"><type>"persona-store-removed"</type></link> signals, <emphasis>then</emphasis> call <link linkend="folks-backend-prepare"><function>folks_backend_prepare()</function></link>, otherwise a race condition may occur between emission of <link linkend="FolksBackend-persona-store-added"><type>"persona-store-added"</type></link> and your code connecting to it.</para>
 */
/**
 * FolksBackendClass:
 * @disable_persona_store: virtual method called by <link linkend="folks-backend-disable-persona-store"><function>folks_backend_disable_persona_store()</function></link>
 * @enable_persona_store: virtual method called by <link linkend="folks-backend-enable-persona-store"><function>folks_backend_enable_persona_store()</function></link>
 * @set_persona_stores: virtual method called by <link linkend="folks-backend-set-persona-stores"><function>folks_backend_set_persona_stores()</function></link>
 * @prepare: virtual method called by <link linkend="folks-backend-prepare"><function>folks_backend_prepare()</function></link>
 * @prepare_finish: asynchronous finish function for <structfield>prepare</structfield>, called by <link linkend="folks-backend-prepare"><function>folks_backend_prepare()</function></link>
 * @unprepare: virtual method called by <link linkend="folks-backend-unprepare"><function>folks_backend_unprepare()</function></link>
 * @unprepare_finish: asynchronous finish function for <structfield>unprepare</structfield>, called by <link linkend="folks-backend-unprepare"><function>folks_backend_unprepare()</function></link>
 * @get_is_prepared: getter method for the abstract property <link linkend="FolksBackend--is-prepared"><type>"is-prepared"</type></link>
 * @get_is_quiescent: getter method for the abstract property <link linkend="FolksBackend--is-quiescent"><type>"is-quiescent"</type></link>
 * @get_name: getter method for the abstract property <link linkend="FolksBackend--name"><type>"name"</type></link>
 * @get_persona_stores: getter method for the abstract property <link linkend="FolksBackend--persona-stores"><type>"persona-stores"</type></link>
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-BACKEND:CAPS"><literal>FOLKS_TYPE_BACKEND</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
