/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.InvertableType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StoredValue;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.misc.document.LazyDocument;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.response.DocsStreamer;
import org.apache.solr.response.ResultContext;
import org.apache.solr.schema.AbstractEnumField;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.LatLonPointSpatialField;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.DocValuesIteratorCache;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrDocumentFetcher {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrIndexSearcher searcher;
    private final int nLeaves;
    private final boolean enableLazyFieldLoading;
    private final SolrCache<Integer, Document> documentCache;
    private final Set<String> allStored;
    private final Set<String> dvsCanSubstituteStored;
    private final Set<String> allNonStoredDVs;
    private final Set<String> nonStoredDVsUsedAsStored;
    private final Set<String> nonStoredDVsWithoutCopyTargets;
    private static int largeValueLengthCacheThreshold = Integer.getInteger("solr.largeField.cacheThreshold", 524288);
    private final Set<String> largeFields;
    private final Collection<String>[] storedHighlightFieldNames;
    private final Collection<String>[] indexedFieldNames;
    private final StoredFields storedFields;

    private SolrDocumentFetcher(SolrDocumentFetcher template, StoredFields storedFields) {
        this.searcher = template.searcher;
        this.nLeaves = template.nLeaves;
        this.enableLazyFieldLoading = template.enableLazyFieldLoading;
        this.documentCache = template.documentCache;
        this.nonStoredDVsUsedAsStored = template.nonStoredDVsUsedAsStored;
        this.allNonStoredDVs = template.allNonStoredDVs;
        this.nonStoredDVsWithoutCopyTargets = template.nonStoredDVsWithoutCopyTargets;
        this.largeFields = template.largeFields;
        this.dvsCanSubstituteStored = template.dvsCanSubstituteStored;
        this.allStored = template.allStored;
        this.storedHighlightFieldNames = template.indexedFieldNames;
        this.indexedFieldNames = template.indexedFieldNames;
        this.storedFields = storedFields;
    }

    protected SolrDocumentFetcher clone() {
        try {
            return new SolrDocumentFetcher(this, this.searcher.getIndexReader().storedFields());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    SolrDocumentFetcher(SolrIndexSearcher searcher, SolrConfig solrConfig, boolean cachingEnabled) {
        this.searcher = searcher;
        this.nLeaves = searcher.getTopReaderContext().leaves().size();
        this.documentCache = cachingEnabled ? (solrConfig.documentCacheConfig == null ? null : solrConfig.documentCacheConfig.newInstance()) : null;
        this.enableLazyFieldLoading = solrConfig.enableLazyFieldLoading && this.documentCache != null;
        HashSet<String> nonStoredDVsUsedAsStored = new HashSet<String>();
        HashSet<String> allNonStoredDVs = new HashSet<String>();
        HashSet<String> nonStoredDVsWithoutCopyTargets = new HashSet<String>();
        HashSet<String> storedLargeFields = new HashSet<String>();
        HashSet<String> dvsCanSubstituteStored = new HashSet<String>();
        HashSet<String> allStoreds = new HashSet<String>();
        for (FieldInfo fieldInfo : searcher.getFieldInfos()) {
            SchemaField schemaField = searcher.getSchema().getFieldOrNull(fieldInfo.name);
            if (schemaField == null) continue;
            if (this.canSubstituteDvForStored(fieldInfo, schemaField)) {
                dvsCanSubstituteStored.add(fieldInfo.name);
            }
            if (schemaField.stored()) {
                allStoreds.add(fieldInfo.name);
            }
            if (!schemaField.stored() && schemaField.hasDocValues()) {
                if (schemaField.useDocValuesAsStored()) {
                    nonStoredDVsUsedAsStored.add(fieldInfo.name);
                }
                allNonStoredDVs.add(fieldInfo.name);
                if (!searcher.getSchema().isCopyFieldTarget(schemaField)) {
                    nonStoredDVsWithoutCopyTargets.add(fieldInfo.name);
                }
            }
            if (!schemaField.stored() || !schemaField.isLarge()) continue;
            storedLargeFields.add(schemaField.getName());
        }
        this.nonStoredDVsUsedAsStored = Collections.unmodifiableSet(nonStoredDVsUsedAsStored);
        this.allNonStoredDVs = Collections.unmodifiableSet(allNonStoredDVs);
        this.nonStoredDVsWithoutCopyTargets = Collections.unmodifiableSet(nonStoredDVsWithoutCopyTargets);
        this.largeFields = Collections.unmodifiableSet(storedLargeFields);
        this.dvsCanSubstituteStored = Collections.unmodifiableSet(dvsCanSubstituteStored);
        this.allStored = Collections.unmodifiableSet(allStoreds);
        this.storedFields = null;
        this.storedHighlightFieldNames = new Collection[1];
        this.indexedFieldNames = new Collection[1];
    }

    private boolean canSubstituteDvForStored(FieldInfo fieldInfo, SchemaField schemaField) {
        if (!schemaField.hasDocValues() || !schemaField.stored()) {
            return false;
        }
        if (schemaField.multiValued()) {
            return false;
        }
        DocValuesType docValuesType = fieldInfo.getDocValuesType();
        NumberType numberType = schemaField.getType().getNumberType();
        return numberType != null || docValuesType != DocValuesType.SORTED_NUMERIC && docValuesType != DocValuesType.NUMERIC;
    }

    public boolean isLazyFieldLoadingEnabled() {
        return this.enableLazyFieldLoading;
    }

    public SolrCache<Integer, Document> getDocumentCache() {
        return this.documentCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getStoredHighlightFieldNames() {
        Collection<String>[] collectionArray = this.storedHighlightFieldNames;
        synchronized (this.storedHighlightFieldNames) {
            if (this.storedHighlightFieldNames[0] == null) {
                ArrayList<String> storedHighlightFieldNames = new ArrayList<String>();
                for (FieldInfo fieldInfo : this.searcher.getFieldInfos()) {
                    String fieldName = fieldInfo.name;
                    try {
                        SchemaField field = this.searcher.getSchema().getField(fieldName);
                        if (!field.stored() || !(field.getType() instanceof TextField) && !(field.getType() instanceof StrField)) continue;
                        storedHighlightFieldNames.add(fieldName);
                    }
                    catch (RuntimeException e) {
                        log.warn("Field [{}] found in index, but not defined in schema.", (Object)fieldName);
                    }
                }
                this.storedHighlightFieldNames[0] = storedHighlightFieldNames;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.storedHighlightFieldNames[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getIndexedFieldNames() {
        Collection<String>[] collectionArray = this.indexedFieldNames;
        synchronized (this.indexedFieldNames) {
            if (this.indexedFieldNames[0] == null) {
                ArrayList<String> indexedFieldNames = new ArrayList<String>();
                for (FieldInfo fieldInfo : this.searcher.getFieldInfos()) {
                    if (fieldInfo.getIndexOptions() == IndexOptions.NONE) continue;
                    indexedFieldNames.add(fieldInfo.name);
                }
                this.indexedFieldNames[0] = indexedFieldNames;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.indexedFieldNames[0];
        }
    }

    public Document doc(int docId) throws IOException {
        return this.doc(docId, (Set<String>)null);
    }

    public Document doc(int i, Set<String> fields) throws IOException {
        if (this.documentCache != null) {
            Set<String> getFields = this.enableLazyFieldLoading ? fields : null;
            Document d = this.documentCache.computeIfAbsent(i, docId -> this.docNC((int)docId, getFields));
            if (d == null) {
                return this.docNC(i, fields);
            }
            return d;
        }
        return this.docNC(i, fields);
    }

    private Document docNC(int i, Set<String> fields) throws IOException {
        SolrDocumentStoredFieldVisitor visitor = new SolrDocumentStoredFieldVisitor(fields, (IndexReader)this.searcher.getIndexReader(), i);
        this.storedFields.document(i, (StoredFieldVisitor)visitor);
        return visitor.getDocument();
    }

    public SolrDocument solrDoc(int luceneDocId, SolrReturnFields solrReturnFields) {
        Supplier<RetrieveFieldsOptimizer> rfoSupplier = () -> new RetrieveFieldsOptimizer(solrReturnFields);
        return solrReturnFields.getFetchOptimizer(rfoSupplier).getSolrDoc(luceneDocId);
    }

    public void doc(int docId, StoredFieldVisitor visitor) throws IOException {
        if (this.documentCache != null) {
            Document cached = this.doc(docId);
            this.visitFromCached(cached, visitor);
        } else {
            this.storedFields.document(docId, visitor);
        }
    }

    private void visitFromCached(Document document, StoredFieldVisitor visitor) throws IOException {
        for (IndexableField f : document) {
            FieldInfo info = this.searcher.getFieldInfos().fieldInfo(f.name());
            StoredFieldVisitor.Status needsField = visitor.needsField(info);
            if (needsField == StoredFieldVisitor.Status.STOP) {
                return;
            }
            if (needsField == StoredFieldVisitor.Status.NO) continue;
            BytesRef binaryValue = f.binaryValue();
            if (binaryValue != null) {
                visitor.binaryField(info, this.toByteArrayUnwrapIfPossible(binaryValue));
                continue;
            }
            Number numericValue = f.numericValue();
            if (numericValue != null) {
                if (numericValue instanceof Double) {
                    visitor.doubleField(info, numericValue.doubleValue());
                    continue;
                }
                if (numericValue instanceof Integer) {
                    visitor.intField(info, numericValue.intValue());
                    continue;
                }
                if (numericValue instanceof Float) {
                    visitor.floatField(info, numericValue.floatValue());
                    continue;
                }
                if (numericValue instanceof Long) {
                    visitor.longField(info, numericValue.longValue());
                    continue;
                }
                throw new AssertionError();
            }
            if (f instanceof LargeLazyField) {
                visitor.stringField(info, this.toStringUnwrapIfPossible(((LargeLazyField)f).readBytes()));
                continue;
            }
            visitor.stringField(info, f.stringValue());
        }
    }

    private byte[] toByteArrayUnwrapIfPossible(BytesRef bytesRef) {
        if (bytesRef.offset == 0 && bytesRef.bytes.length == bytesRef.length) {
            return bytesRef.bytes;
        }
        return Arrays.copyOfRange(bytesRef.bytes, bytesRef.offset, bytesRef.offset + bytesRef.length);
    }

    private String toStringUnwrapIfPossible(BytesRef bytesRef) {
        if (bytesRef.offset == 0 && bytesRef.bytes.length == bytesRef.length) {
            return new String(bytesRef.bytes, StandardCharsets.UTF_8);
        }
        return new String(bytesRef.bytes, bytesRef.offset, bytesRef.offset + bytesRef.length, StandardCharsets.UTF_8);
    }

    public void decorateDocValueFields(SolrDocumentBase<?, ?> doc, int docid, Set<String> fields, DocValuesIteratorCache reuseDvIters) throws IOException {
        List leafContexts = this.searcher.getLeafContexts();
        int subIndex = ReaderUtil.subIndex((int)docid, (List)leafContexts);
        int localId = docid - ((LeafReaderContext)leafContexts.get((int)subIndex)).docBase;
        LeafReader leafReader = ((LeafReaderContext)leafContexts.get(subIndex)).reader();
        for (String fieldName : fields) {
            Object fieldValue;
            DocValuesIteratorCache.FieldDocValuesSupplier e = reuseDvIters.getSupplier(fieldName);
            if (e == null || (fieldValue = this.decodeDVField(localId, leafReader, subIndex, e)) == null) continue;
            doc.setField(fieldName, fieldValue);
        }
    }

    private Object decodeDVField(int localId, LeafReader leafReader, int readerOrd, DocValuesIteratorCache.FieldDocValuesSupplier e) throws IOException {
        DocValuesType dvType = e.type;
        switch (dvType) {
            case NUMERIC: {
                NumericDocValues ndv = e.getNumericDocValues(localId, leafReader, readerOrd);
                if (ndv == null) {
                    return null;
                }
                long val = ndv.longValue();
                return this.decodeNumberFromDV(e.schemaField, val, false);
            }
            case BINARY: {
                BinaryDocValues bdv = e.getBinaryDocValues(localId, leafReader, readerOrd);
                if (bdv != null) {
                    return BytesRef.deepCopyOf((BytesRef)bdv.binaryValue()).bytes;
                }
                return null;
            }
            case SORTED: {
                SortedDocValues sdv = e.getSortedDocValues(localId, leafReader, readerOrd);
                if (sdv != null) {
                    BytesRef bRef = sdv.lookupOrd(sdv.ordValue());
                    if (e.schemaField.getType() instanceof BoolField) {
                        return e.schemaField.getType().toObject(e.schemaField, bRef);
                    }
                    return bRef.utf8ToString();
                }
                return null;
            }
            case SORTED_NUMERIC: {
                SortedNumericDocValues numericDv = e.getSortedNumericDocValues(localId, leafReader, readerOrd);
                if (numericDv != null) {
                    int docValueCount = numericDv.docValueCount();
                    ArrayList<Object> outValues = new ArrayList<Object>(docValueCount);
                    for (int i = 0; i < docValueCount; ++i) {
                        long number = numericDv.nextValue();
                        Object value = this.decodeNumberFromDV(e.schemaField, number, true);
                        if (value == null) {
                            return null;
                        }
                        if (!e.schemaField.multiValued()) {
                            return value;
                        }
                        outValues.add(value);
                    }
                    assert (outValues.size() > 0);
                    return outValues;
                }
                return null;
            }
            case SORTED_SET: {
                SortedSetDocValues values = e.getSortedSetDocValues(localId, leafReader, readerOrd);
                if (values != null) {
                    ArrayList<Object> outValues = new ArrayList<Object>();
                    long ord = values.nextOrd();
                    while (ord != -1L) {
                        BytesRef value = values.lookupOrd(ord);
                        outValues.add(e.schemaField.getType().toObject(e.schemaField, value));
                        ord = values.nextOrd();
                    }
                    assert (outValues.size() > 0);
                    return outValues;
                }
                return null;
            }
        }
        throw new IllegalStateException();
    }

    private Object decodeNumberFromDV(SchemaField schemaField, long value, boolean sortableNumeric) {
        if (schemaField.getType() instanceof LatLonPointSpatialField) {
            return LatLonPointSpatialField.decodeDocValueToString(value);
        }
        if (schemaField.getType().getNumberType() == null) {
            log.warn("Couldn't decode docValues for field: [{}], schemaField: [{}], numberType is unknown", (Object)schemaField.getName(), (Object)schemaField);
            return null;
        }
        switch (schemaField.getType().getNumberType()) {
            case INTEGER: {
                int raw = (int)value;
                if (schemaField.getType() instanceof AbstractEnumField) {
                    return ((AbstractEnumField)schemaField.getType()).getEnumMapping().intValueToStringValue(raw);
                }
                return raw;
            }
            case LONG: {
                return value;
            }
            case FLOAT: {
                if (sortableNumeric) {
                    return Float.valueOf(NumericUtils.sortableIntToFloat((int)((int)value)));
                }
                return Float.valueOf(Float.intBitsToFloat((int)value));
            }
            case DOUBLE: {
                if (sortableNumeric) {
                    return NumericUtils.sortableLongToDouble((long)value);
                }
                return Double.longBitsToDouble(value);
            }
            case DATE: {
                return new Date(value);
            }
        }
        throw new AssertionError();
    }

    public Set<String> getDvsCanSubstituteStored() {
        return this.dvsCanSubstituteStored;
    }

    public Set<String> getAllStored() {
        return this.allStored;
    }

    public Set<String> getNonStoredDVs(boolean onlyUseDocValuesAsStored) {
        return onlyUseDocValuesAsStored ? this.nonStoredDVsUsedAsStored : this.allNonStoredDVs;
    }

    public Set<String> getNonStoredDVsWithoutCopyTargets() {
        return this.nonStoredDVsWithoutCopyTargets;
    }

    class RetrieveFieldsOptimizer {
        private final Set<String> storedFields;
        private final Set<String> dvFields;
        private final SolrReturnFields solrReturnFields;
        private final DocValuesIteratorCache reuseDvIters;

        RetrieveFieldsOptimizer(SolrReturnFields solrReturnFields) {
            this.storedFields = this.calcStoredFieldsForReturn(solrReturnFields);
            this.dvFields = this.calcDocValueFieldsForReturn(solrReturnFields);
            this.solrReturnFields = solrReturnFields;
            if (this.storedFields != null && SolrDocumentFetcher.this.dvsCanSubstituteStored.containsAll(this.storedFields)) {
                this.dvFields.addAll(this.storedFields);
                this.storedFields.clear();
            }
            this.reuseDvIters = this.dvFields.isEmpty() ? null : new DocValuesIteratorCache(SolrDocumentFetcher.this.searcher);
        }

        private boolean returnStoredFields() {
            return this.storedFields == null || !this.storedFields.isEmpty();
        }

        private boolean returnDVFields() {
            return !this.dvFields.isEmpty();
        }

        private Set<String> getStoredFields() {
            return this.storedFields;
        }

        private Set<String> getDvFields() {
            return this.dvFields;
        }

        private ReturnFields getReturnFields() {
            return this.solrReturnFields;
        }

        private Set<String> calcStoredFieldsForReturn(ReturnFields returnFields) {
            HashSet<String> storedFields = new HashSet<String>();
            Set<String> fnames = returnFields.getLuceneFieldNames();
            if (returnFields.wantsAllFields()) {
                return null;
            }
            if (returnFields.hasPatternMatching()) {
                for (String s : SolrDocumentFetcher.this.getAllStored()) {
                    if (!returnFields.wantsField(s)) continue;
                    storedFields.add(s);
                }
            } else if (fnames != null) {
                storedFields.addAll(fnames);
                storedFields.removeIf(name -> {
                    SchemaField schemaField = SolrDocumentFetcher.this.searcher.getSchema().getFieldOrNull((String)name);
                    if (schemaField == null) {
                        return false;
                    }
                    if (schemaField.stored() && schemaField.multiValued()) {
                        return false;
                    }
                    return !schemaField.stored();
                });
            }
            storedFields.remove("score");
            return storedFields;
        }

        private Set<String> calcDocValueFieldsForReturn(ReturnFields returnFields) {
            HashSet<String> result = new HashSet<String>();
            if (returnFields.wantsAllFields()) {
                result.addAll(SolrDocumentFetcher.this.getNonStoredDVs(true));
                Set<String> fieldNames = returnFields.getLuceneFieldNames(true);
                if (fieldNames != null) {
                    for (String fl : fieldNames) {
                        if (!SolrDocumentFetcher.this.getNonStoredDVs(false).contains(fl)) continue;
                        result.add(fl);
                    }
                }
            } else if (returnFields.hasPatternMatching()) {
                for (String s : SolrDocumentFetcher.this.getNonStoredDVs(true)) {
                    if (!returnFields.wantsField(s)) continue;
                    result.add(s);
                }
            } else {
                Set<String> fnames = returnFields.getLuceneFieldNames();
                if (fnames != null) {
                    result.addAll(fnames);
                    result.retainAll(SolrDocumentFetcher.this.getNonStoredDVs(false));
                }
            }
            return result;
        }

        private SolrDocument getSolrDoc(int luceneDocId) {
            SolrDocument sdoc = null;
            try {
                if (this.returnStoredFields()) {
                    Document doc = SolrDocumentFetcher.this.doc(luceneDocId, this.getStoredFields());
                    sdoc = DocsStreamer.convertLuceneDocToSolrDoc(doc, SolrDocumentFetcher.this.searcher.getSchema(), this.getReturnFields());
                    if (!this.returnDVFields()) {
                        this.solrReturnFields.setFieldSources(SolrReturnFields.FIELD_SOURCES.ALL_FROM_STORED);
                        return sdoc;
                    }
                    this.solrReturnFields.setFieldSources(SolrReturnFields.FIELD_SOURCES.MIXED_SOURCES);
                } else {
                    sdoc = new SolrDocument();
                    this.solrReturnFields.setFieldSources(SolrReturnFields.FIELD_SOURCES.ALL_FROM_DV);
                }
                if (this.returnDVFields()) {
                    SolrDocumentFetcher.this.decorateDocValueFields((SolrDocumentBase<?, ?>)sdoc, luceneDocId, this.getDvFields(), this.reuseDvIters);
                }
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading document with docId " + luceneDocId, (Throwable)e);
            }
            return sdoc;
        }
    }

    class LargeLazyField
    implements IndexableField {
        final String name;
        final int docId;
        BytesRef cachedBytes;

        private LargeLazyField(String name, int docId) {
            this.name = name;
            this.docId = docId;
        }

        public String toString() {
            return this.fieldType().toString() + "<" + this.name() + ">";
        }

        public String name() {
            return this.name;
        }

        public IndexableFieldType fieldType() {
            return SolrDocumentFetcher.this.searcher.getSchema().getField(this.name());
        }

        public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
            return analyzer.tokenStream(this.name(), this.stringValue());
        }

        synchronized boolean hasBeenLoaded() {
            return this.cachedBytes != null;
        }

        public synchronized String stringValue() {
            try {
                return this.readBytes().utf8ToString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        synchronized BytesRef readBytes() throws IOException {
            if (this.cachedBytes != null) {
                return this.cachedBytes;
            }
            final BytesRef bytesRef = new BytesRef();
            SolrDocumentFetcher.this.storedFields.document(this.docId, new StoredFieldVisitor(){
                boolean done = false;

                public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
                    if (this.done) {
                        return StoredFieldVisitor.Status.STOP;
                    }
                    return fieldInfo.name.equals(LargeLazyField.this.name()) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
                }

                public void stringField(FieldInfo fieldInfo, String value) throws IOException {
                    Objects.requireNonNull(value, "String value should not be null");
                    bytesRef.bytes = value.getBytes(StandardCharsets.UTF_8);
                    bytesRef.length = bytesRef.bytes.length;
                    this.done = true;
                }

                public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
                    throw new UnsupportedOperationException("'large' binary fields are not (yet) supported");
                }
            });
            if (bytesRef.length < largeValueLengthCacheThreshold) {
                this.cachedBytes = bytesRef;
                return this.cachedBytes;
            }
            return bytesRef;
        }

        public BytesRef binaryValue() {
            return null;
        }

        public Reader readerValue() {
            return null;
        }

        public Number numericValue() {
            return null;
        }

        public StoredValue storedValue() {
            return new StoredValue(this.stringValue());
        }

        public InvertableType invertableType() {
            return null;
        }
    }

    private class SolrDocumentStoredFieldVisitor
    extends DocumentStoredFieldVisitor {
        private final Document doc;
        private final LazyDocument lazyFieldProducer;
        private final int docId;
        private final boolean addLargeFieldsLazily;

        SolrDocumentStoredFieldVisitor(Set<String> toLoad, IndexReader reader, int docId) {
            super(toLoad);
            this.docId = docId;
            this.doc = this.getDocument();
            this.lazyFieldProducer = toLoad != null && SolrDocumentFetcher.this.enableLazyFieldLoading ? new LazyDocument(reader, docId) : null;
            this.addLargeFieldsLazily = SolrDocumentFetcher.this.documentCache != null && !SolrDocumentFetcher.this.largeFields.isEmpty();
        }

        public void stringField(FieldInfo fieldInfo, String value) throws IOException {
            Predicate<String> readAsBytes = ResultContext.READASBYTES.get();
            if (readAsBytes != null && readAsBytes.test(fieldInfo.name)) {
                FieldType ft = new FieldType((IndexableFieldType)org.apache.lucene.document.TextField.TYPE_STORED);
                ft.setStoreTermVectors(fieldInfo.hasVectors());
                ft.setOmitNorms(fieldInfo.omitsNorms());
                ft.setIndexOptions(fieldInfo.getIndexOptions());
                Objects.requireNonNull(value, "String value should not be null");
                this.doc.add((IndexableField)new StoredField(fieldInfo.name, value, ft));
            } else {
                super.stringField(fieldInfo, value);
            }
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            StoredFieldVisitor.Status status = super.needsField(fieldInfo);
            assert (status != StoredFieldVisitor.Status.STOP) : "Status.STOP not supported or expected";
            if (this.addLargeFieldsLazily && SolrDocumentFetcher.this.largeFields.contains(fieldInfo.name)) {
                if (this.lazyFieldProducer != null || status == StoredFieldVisitor.Status.YES) {
                    this.doc.add((IndexableField)new LargeLazyField(fieldInfo.name, this.docId));
                }
                return StoredFieldVisitor.Status.NO;
            }
            if (status == StoredFieldVisitor.Status.NO && this.lazyFieldProducer != null) {
                this.doc.add(this.lazyFieldProducer.getField(fieldInfo));
            }
            return status;
        }
    }
}

