/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyDescriptor;
import javax.swing.JTextField;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.DataObject;
import net.sf.sdedit.ui.components.configuration.configurators.StringConfigurator;

public class FreeStringConfigurator<C extends DataObject>
extends StringConfigurator<C>
implements FocusListener,
KeyListener {
    private static final long serialVersionUID = -8187247399759901746L;
    private JTextField textField;

    public FreeStringConfigurator(Bean<C> bean, PropertyDescriptor property) {
        super(bean, property);
        this.initialize();
    }

    private void initialize() {
        this.getBottomPanel().setLayout(new BorderLayout());
        this.textField = new JTextField((String)this.getValue());
        this.getBottomPanel().add((Component)this.textField, "Center");
        this.textField.addKeyListener(this);
    }

    @Override
    protected void refresh(String value) {
        this.textField.setText(value);
    }

    @Override
    protected void _actionPerformed(ActionEvent e) {
        int c = this.textField.getCaretPosition();
        this.applyValue(this.textField.getText());
        this.textField.setCaretPosition(c);
    }

    @Override
    protected void _setEnabled(boolean enabled) {
        if (this.textField != null) {
            this.textField.setEnabled(enabled);
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.actionPerformed(null);
    }

    @Override
    public void focus() {
        this.textField.selectAll();
        this.textField.requestFocusInWindow();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.actionPerformed(null);
    }
}

