"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.extend = void 0;
const extend_1 = __importDefault(require("./extend"));
const toZigbee_1 = __importDefault(require("../converters/toZigbee"));
const ledvanceExtend = {
    light_onoff_brightness: (options = {}) => {
        options = { disablePowerOnBehavior: true, ...options };
        return {
            ...extend_1.default.light_onoff_brightness(options),
            toZigbee: extend_1.default.light_onoff_brightness(options).toZigbee.concat([toZigbee_1.default.ledvance_commands]),
        };
    },
    light_onoff_brightness_colortemp: (options = {}) => {
        options = { disablePowerOnBehavior: true, ...options };
        return {
            ...extend_1.default.light_onoff_brightness_colortemp({ disableColorTempStartup: true, ...options }),
            toZigbee: extend_1.default.light_onoff_brightness_colortemp({ disableColorTempStartup: true, ...options })
                .toZigbee.concat([toZigbee_1.default.ledvance_commands]),
        };
    },
    light_onoff_brightness_color: (options = {}) => {
        options = { disablePowerOnBehavior: true, ...options };
        return {
            ...extend_1.default.light_onoff_brightness_color({ supportsHueAndSaturation: true, ...options }),
            toZigbee: extend_1.default.light_onoff_brightness_color({ supportsHueAndSaturation: true, ...options }).toZigbee.concat([toZigbee_1.default.ledvance_commands]),
        };
    },
    light_onoff_brightness_colortemp_color: (options = {}) => {
        options = { disablePowerOnBehavior: true, ...options };
        return {
            ...extend_1.default.light_onoff_brightness_colortemp_color({ supportsHueAndSaturation: true, disableColorTempStartup: true, ...options }),
            toZigbee: extend_1.default.light_onoff_brightness_colortemp_color({ supportsHueAndSaturation: true, disableColorTempStartup: true, ...options })
                .toZigbee.concat([toZigbee_1.default.ledvance_commands]),
        };
    },
};
exports.extend = ledvanceExtend;
exports.extend = ledvanceExtend;
//# sourceMappingURL=ledvance.js.map