"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IsInViewport = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2019 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const react_1 = require("react");
const IsInViewport = (_a) => {
    var { onEnterViewport, disabled = false, checkViewportOnce = false } = _a, props = __rest(_a, ["onEnterViewport", "disabled", "checkViewportOnce"]);
    const element = (0, react_1.useRef)();
    (0, react_1.useEffect)(() => {
        let observer = undefined;
        if (onEnterViewport && !disabled) {
            observer = new IntersectionObserver(([{ isIntersecting }]) => {
                if (isIntersecting) {
                    if (checkViewportOnce) {
                        observer.disconnect();
                    }
                    if (onEnterViewport && !disabled) {
                        onEnterViewport();
                    }
                }
            });
            observer.observe(element.current);
        }
        return () => {
            if (observer) {
                observer.disconnect();
            }
        };
    }, [onEnterViewport]);
    return (0, jsx_runtime_1.jsx)("div", Object.assign({ ref: element }, props));
};
exports.IsInViewport = IsInViewport;
