/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.catalina.realm.DigestCredentialHandlerBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.security.ConcurrentMessageDigest;

public class MessageDigestCredentialHandler
extends DigestCredentialHandlerBase {
    private static final Log log = LogFactory.getLog(MessageDigestCredentialHandler.class);
    public static final int DEFAULT_ITERATIONS = 1;
    private Charset encoding = StandardCharsets.UTF_8;
    private String algorithm = null;

    public String getEncoding() {
        return this.encoding.name();
    }

    public void setEncoding(String string) {
        if (string == null) {
            this.encoding = StandardCharsets.UTF_8;
        } else {
            try {
                this.encoding = B2CConverter.getCharset((String)string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.error((Object)sm.getString("mdCredentialHandler.unknownEncoding", new Object[]{string, this.encoding.name()}));
            }
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void setAlgorithm(String string) throws NoSuchAlgorithmException {
        ConcurrentMessageDigest.init((String)string);
        this.algorithm = string;
    }

    @Override
    public boolean matches(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (this.getAlgorithm() == null) {
            return DigestCredentialHandlerBase.equals(string, string2, false);
        }
        if (string2.startsWith("{MD5}") || string2.startsWith("{SHA}")) {
            String string3 = string2.substring(5);
            byte[] byArray = ConcurrentMessageDigest.digest((String)this.getAlgorithm(), (byte[][])new byte[][]{string.getBytes(StandardCharsets.ISO_8859_1)});
            String string4 = Base64.encodeBase64String((byte[])byArray);
            return DigestCredentialHandlerBase.equals(string4, string3, false);
        }
        if (string2.startsWith("{SSHA}")) {
            String string5 = string2.substring(6);
            byte[] byArray = Base64.decodeBase64((String)string5);
            byte[] byArray2 = new byte[20];
            System.arraycopy(byArray, 0, byArray2, 0, 20);
            int n = byArray.length - 20;
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray, 20, byArray3, 0, n);
            byte[] byArray4 = ConcurrentMessageDigest.digest((String)this.getAlgorithm(), (byte[][])new byte[][]{string.getBytes(StandardCharsets.ISO_8859_1), byArray3});
            return Arrays.equals(byArray4, byArray2);
        }
        if (string2.indexOf(36) > -1) {
            return this.matchesSaltIterationsEncoded(string, string2);
        }
        String string6 = this.mutate(string, null, 1);
        if (string6 == null) {
            return false;
        }
        return string2.equalsIgnoreCase(string6);
    }

    @Override
    protected String mutate(String string, byte[] byArray, int n) {
        if (this.algorithm == null) {
            return string;
        }
        byte[] byArray2 = string.getBytes(this.encoding);
        byte[] byArray3 = byArray == null ? ConcurrentMessageDigest.digest((String)this.algorithm, (int)n, (byte[][])new byte[][]{byArray2}) : ConcurrentMessageDigest.digest((String)this.algorithm, (int)n, (byte[][])new byte[][]{byArray, byArray2});
        return HexUtils.toHexString((byte[])byArray3);
    }

    @Override
    protected int getDefaultIterations() {
        return 1;
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

