/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkArg;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexPartialMatch;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandLinkActivity
extends SingleLineCommand2<ActivityDiagram> {
    public CommandLinkActivity() {
        super(CommandLinkActivity.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandLinkActivity.class.getName(), RegexLeaf.start(), new RegexOptional((IRegex)new RegexOr("FIRST", new RegexLeaf("STAR", "(\\(\\*(top)?\\))"), new RegexLeaf("CODE", "([%pLN][%pLN_.]*)"), new RegexLeaf("BAR", "(?:==+)[%s]*([%pLN_.]+)[%s]*(?:==+)"), new RegexLeaf("QUOTED", "[%g]([^%g]+)[%g](?:[%s]+as[%s]+([%pLN_.]+))?"))), StereotypePattern.optional("STEREOTYPE"), ColorParser.exp2(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, new RegexLeaf("ARROW_BODY1", "([-.]+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_DIRECTION", "(\\*|left|right|up|down|le?|ri?|up?|do?)?"), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_BODY2", "([-.]*)"), new RegexLeaf("\\>"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("BRACKET", "\\[([^\\]*]+[^\\]]*)\\]")), RegexLeaf.spaceZeroOrMore(), new RegexOr("FIRST2", new RegexLeaf("STAR2", "(\\(\\*(top|\\d+)?\\))"), new RegexLeaf("OPENBRACKET2", "(\\{)"), new RegexLeaf("CODE2", "([%pLN][%pLN_.]*)"), new RegexLeaf("BAR2", "(?:==+)[%s]*([%pLN_.]+)[%s]*(?:==+)"), new RegexLeaf("QUOTED2", "[%g]([^%g]+)[%g](?:[%s]+as[%s]+([%pLN][%pLN_.]*))?"), new RegexLeaf("QUOTED_INVISIBLE2", "(\\w.*?)")), StereotypePattern.optional("STEREOTYPE2"), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("in"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("PARTITION2", "([%g][^%g]+[%g]|\\S+)"))), RegexLeaf.spaceZeroOrMore(), ColorParser.exp3(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        Direction direction;
        Entity entity2;
        Entity entity1 = CommandLinkActivity.getEntity(diagram, arg, true);
        if (entity1 == null) {
            return CommandExecutionResult.error("No such activity");
        }
        if (arg.get("STEREOTYPE", 0) != null) {
            entity1.setStereotype(Stereotype.build(arg.get("STEREOTYPE", 0)));
        }
        if (arg.get("BACKCOLOR", 0) != null) {
            String s = arg.get("BACKCOLOR", 0);
            entity1.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColor(s));
        }
        if ((entity2 = CommandLinkActivity.getEntity(diagram, arg, false)) == null) {
            return CommandExecutionResult.error("No such activity");
        }
        diagram.setLastEntityConsulted(entity2);
        if (arg.get("BACKCOLOR2", 0) != null) {
            String s = arg.get("BACKCOLOR2", 0);
            entity2.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColor(s));
        }
        if (arg.get("STEREOTYPE2", 0) != null) {
            entity2.setStereotype(Stereotype.build(arg.get("STEREOTYPE2", 0)));
        }
        Display linkLabel = Display.getWithNewlines(arg.get("BRACKET", 0));
        String arrowBody1 = CommandLinkClass.notNull(arg.get("ARROW_BODY1", 0));
        String arrowBody2 = CommandLinkClass.notNull(arg.get("ARROW_BODY2", 0));
        String arrowDirection = CommandLinkClass.notNull(arg.get("ARROW_DIRECTION", 0));
        String arrow = StringUtils.manageArrowForCuca(arrowBody1 + arrowDirection + arrowBody2 + ">");
        int lenght = arrow.length() - 1;
        if (arrowDirection.contains("*")) {
            lenght = 2;
        }
        LinkType type = new LinkType(LinkDecor.ARROW, LinkDecor.NONE);
        if ((arrowBody1 + arrowBody2).contains(".")) {
            type = type.goDotted();
        }
        LinkArg linkArg = LinkArg.build(linkLabel, lenght, diagram.getSkinParam().classAttributeIconSize() > 0);
        Link link = new Link(diagram.getEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), entity1, entity2, type, linkArg);
        if (arrowDirection.contains("*")) {
            link.setConstraint(false);
        }
        if ((direction = StringUtils.getArrowDirection(arrowBody1 + arrowDirection + arrowBody2 + ">")) == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        if (arg.get("URL", 0) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url urlLink = urlBuilder.getUrl(arg.get("URL", 0));
            link.setUrl(urlLink);
        }
        link.applyStyle(arg.getLazzy("ARROW_STYLE", 0));
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    static Entity getEntity(ActivityDiagram diagram, RegexResult arg, boolean start) {
        String idShort;
        String suf = start ? "" : "2";
        String openBracket2 = arg.get("OPENBRACKET" + suf, 0);
        if (openBracket2 != null) {
            return diagram.createInnerActivity();
        }
        if (arg.get("STAR" + suf, 0) != null) {
            String suppId = arg.get("STAR" + suf, 1);
            if (start) {
                return diagram.getStart();
            }
            return diagram.getEnd(suppId);
        }
        String partition = arg.get("PARTITION" + suf, 0);
        if (partition != null) {
            partition = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(partition);
        }
        if ((idShort = arg.get("CODE" + suf, 0)) != null) {
            if (partition != null) {
                Quark<Entity> quark = diagram.quarkInContext(true, diagram.cleanId(partition));
                diagram.gotoGroup(quark, Display.getWithNewlines(quark), GroupType.PACKAGE);
            }
            Quark<Entity> ident = diagram.quarkInContext(true, diagram.cleanId(idShort));
            LeafType type = CommandLinkActivity.getTypeIfExisting(diagram, ident);
            Entity result = ident.getData();
            if (result == null) {
                result = diagram.reallyCreateLeaf(ident, Display.getWithNewlines(idShort), type, null);
            }
            if (partition != null) {
                diagram.endGroup();
            }
            return result;
        }
        String bar = arg.get("BAR" + suf, 0);
        if (bar != null) {
            Quark<Entity> quark = diagram.quarkInContext(true, diagram.cleanId(bar));
            Entity result = quark.getData();
            if (result == null) {
                result = diagram.reallyCreateLeaf(quark, Display.getWithNewlines(bar), LeafType.SYNCHRO_BAR, null);
            }
            return result;
        }
        RegexPartialMatch quoted = arg.get("QUOTED" + suf);
        if (quoted.get(0) != null) {
            Quark<Entity> quark;
            String quotedString;
            String string = quotedString = quoted.get(1) == null ? quoted.get(0) : quoted.get(1);
            if (partition != null) {
                quark = diagram.quarkInContext(true, diagram.cleanId(partition));
                diagram.gotoGroup(quark, Display.getWithNewlines(partition), GroupType.PACKAGE);
            }
            quark = diagram.quarkInContext(true, diagram.cleanId(quotedString));
            LeafType type = CommandLinkActivity.getTypeIfExisting(diagram, quark);
            Entity result = quark.getData();
            if (result == null) {
                result = diagram.reallyCreateLeaf(quark, Display.getWithNewlines(quoted.get(0)), type, null);
            }
            if (partition != null) {
                diagram.endGroup();
            }
            return result;
        }
        String quoteInvisibleString = arg.get("QUOTED_INVISIBLE" + suf, 0);
        if (quoteInvisibleString != null) {
            Quark<Entity> identInvisible;
            Entity result;
            if (partition != null) {
                Quark<Entity> quark = diagram.quarkInContext(true, diagram.cleanId(partition));
                diagram.gotoGroup(quark, Display.getWithNewlines(quark), GroupType.PACKAGE);
            }
            if ((result = (identInvisible = diagram.quarkInContext(true, diagram.cleanId(quoteInvisibleString))).getData()) == null) {
                result = diagram.reallyCreateLeaf(identInvisible, Display.getWithNewlines(identInvisible.getName()), LeafType.ACTIVITY, null);
            }
            if (partition != null) {
                diagram.endGroup();
            }
            return result;
        }
        String first = arg.get("FIRST" + suf, 0);
        if (first == null) {
            return diagram.getLastEntityConsulted();
        }
        return null;
    }

    private static LeafType getTypeIfExisting(ActivityDiagram system, Quark<Entity> code) {
        return LeafType.ACTIVITY;
    }
}

