/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.core.InternalApi;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

@InternalApi
public class GaxProperties {
    private static final String DEFAULT_VERSION = "";
    private static final String GAX_VERSION = GaxProperties.getLibraryVersion(GaxProperties.class, "version.gax");
    private static final String JAVA_VERSION = GaxProperties.getRuntimeVersion();

    private GaxProperties() {
    }

    public static String getLibraryVersion(Class<?> libraryClass) {
        String version = libraryClass.getPackage().getImplementationVersion();
        return version != null ? version : DEFAULT_VERSION;
    }

    public static String getLibraryVersion(Class<?> libraryClass, String propertyName) {
        String version = null;
        if (!libraryClass.equals(GaxProperties.class) && !DEFAULT_VERSION.equals(version = GaxProperties.getLibraryVersion(libraryClass))) {
            return version;
        }
        try (InputStream in = libraryClass.getResourceAsStream("/dependencies.properties");){
            if (in != null) {
                Properties props = new Properties();
                props.load(in);
                version = props.getProperty(propertyName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version != null ? version : DEFAULT_VERSION;
    }

    public static String getJavaVersion() {
        String imageCode = System.getProperty("org.graalvm.nativeimage.imagecode");
        if (imageCode != null && imageCode.equals("runtime")) {
            return System.getProperty("java.version") + "-graalvm";
        }
        return JAVA_VERSION;
    }

    public static String getGaxVersion() {
        return GAX_VERSION;
    }

    private static String getRuntimeVersion() {
        return System.getProperty("java.version");
    }
}

