/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchParseException;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.MemorySizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.index.IndexModule;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.memory.NativeMemoryCacheManager;
import org.opensearch.knn.index.memory.NativeMemoryCacheManagerDto;
import org.opensearch.monitor.jvm.JvmInfo;
import org.opensearch.monitor.os.OsProbe;

public class KNNSettings {
    private static final Logger logger = LogManager.getLogger(KNNSettings.class);
    private static KNNSettings INSTANCE;
    private static final OsProbe osProbe;
    private static final int INDEX_THREAD_QTY_MAX = 32;
    public static final String KNN_SPACE_TYPE = "index.knn.space_type";
    public static final String KNN_ALGO_PARAM_M = "index.knn.algo_param.m";
    public static final String KNN_ALGO_PARAM_EF_CONSTRUCTION = "index.knn.algo_param.ef_construction";
    public static final String KNN_ALGO_PARAM_EF_SEARCH = "index.knn.algo_param.ef_search";
    public static final String KNN_ALGO_PARAM_INDEX_THREAD_QTY = "knn.algo_param.index_thread_qty";
    public static final String KNN_MEMORY_CIRCUIT_BREAKER_ENABLED = "knn.memory.circuit_breaker.enabled";
    public static final String KNN_MEMORY_CIRCUIT_BREAKER_LIMIT = "knn.memory.circuit_breaker.limit";
    public static final String KNN_CIRCUIT_BREAKER_TRIGGERED = "knn.circuit_breaker.triggered";
    public static final String KNN_CACHE_ITEM_EXPIRY_ENABLED = "knn.cache.item.expiry.enabled";
    public static final String KNN_CACHE_ITEM_EXPIRY_TIME_MINUTES = "knn.cache.item.expiry.minutes";
    public static final String KNN_PLUGIN_ENABLED = "knn.plugin.enabled";
    public static final String KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE = "knn.circuit_breaker.unset.percentage";
    public static final String KNN_INDEX = "index.knn";
    public static final String MODEL_INDEX_NUMBER_OF_SHARDS = "knn.model.index.number_of_shards";
    public static final String MODEL_INDEX_NUMBER_OF_REPLICAS = "knn.model.index.number_of_replicas";
    public static final String MODEL_CACHE_SIZE_LIMIT = "knn.model.cache.size.limit";
    public static final String ADVANCED_FILTERED_EXACT_SEARCH_THRESHOLD = "index.knn.advanced.filtered_exact_search_threshold";
    public static final String INDEX_KNN_DEFAULT_SPACE_TYPE = "l2";
    public static final Integer INDEX_KNN_DEFAULT_ALGO_PARAM_M;
    public static final Integer INDEX_KNN_DEFAULT_ALGO_PARAM_EF_SEARCH;
    public static final Integer INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION;
    public static final Integer KNN_DEFAULT_ALGO_PARAM_INDEX_THREAD_QTY;
    public static final Integer KNN_DEFAULT_CIRCUIT_BREAKER_UNSET_PERCENTAGE;
    public static final Integer KNN_DEFAULT_MODEL_CACHE_SIZE_LIMIT_PERCENTAGE;
    public static final Integer KNN_MAX_MODEL_CACHE_SIZE_LIMIT_PERCENTAGE;
    public static final String KNN_DEFAULT_MEMORY_CIRCUIT_BREAKER_LIMIT = "50%";
    public static final Integer ADVANCED_FILTERED_EXACT_SEARCH_THRESHOLD_DEFAULT_VALUE;
    public static final Setting<String> INDEX_KNN_SPACE_TYPE;
    public static final Setting<Integer> INDEX_KNN_ALGO_PARAM_M_SETTING;
    public static final Setting<Integer> INDEX_KNN_ALGO_PARAM_EF_SEARCH_SETTING;
    public static final Setting<Integer> INDEX_KNN_ALGO_PARAM_EF_CONSTRUCTION_SETTING;
    public static final Setting<Integer> MODEL_INDEX_NUMBER_OF_SHARDS_SETTING;
    public static final Setting<Integer> MODEL_INDEX_NUMBER_OF_REPLICAS_SETTING;
    public static final Setting<Integer> ADVANCED_FILTERED_EXACT_SEARCH_THRESHOLD_SETTING;
    public static final Setting<ByteSizeValue> MODEL_CACHE_SIZE_LIMIT_SETTING;
    public static final Setting<Boolean> IS_KNN_INDEX_SETTING;
    public static final Setting<Integer> KNN_ALGO_PARAM_INDEX_THREAD_QTY_SETTING;
    public static final Setting<Boolean> KNN_CIRCUIT_BREAKER_TRIGGERED_SETTING;
    public static final Setting<Double> KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE_SETTING;
    public static Map<String, Setting<?>> dynamicCacheSettings;
    private ClusterService clusterService;
    private Client client;

    private KNNSettings() {
    }

    public static synchronized KNNSettings state() {
        if (INSTANCE == null) {
            INSTANCE = new KNNSettings();
        }
        return INSTANCE;
    }

    private void setSettingsUpdateConsumers() {
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(updatedSettings -> {
            NativeMemoryCacheManagerDto.NativeMemoryCacheManagerDtoBuilder builder = NativeMemoryCacheManagerDto.builder();
            builder.isWeightLimited(updatedSettings.getAsBoolean(KNN_MEMORY_CIRCUIT_BREAKER_ENABLED, (Boolean)this.getSettingValue(KNN_MEMORY_CIRCUIT_BREAKER_ENABLED)));
            builder.maxWeight(((ByteSizeValue)this.getSettingValue(KNN_MEMORY_CIRCUIT_BREAKER_LIMIT)).getKb());
            if (updatedSettings.hasValue(KNN_MEMORY_CIRCUIT_BREAKER_LIMIT)) {
                builder.maxWeight(((ByteSizeValue)this.getSetting(KNN_MEMORY_CIRCUIT_BREAKER_LIMIT).get(updatedSettings)).getKb());
            }
            builder.isExpirationLimited(updatedSettings.getAsBoolean(KNN_CACHE_ITEM_EXPIRY_ENABLED, (Boolean)this.getSettingValue(KNN_CACHE_ITEM_EXPIRY_ENABLED)));
            builder.expiryTimeInMin(updatedSettings.getAsTime(KNN_CACHE_ITEM_EXPIRY_TIME_MINUTES, (TimeValue)this.getSettingValue(KNN_CACHE_ITEM_EXPIRY_TIME_MINUTES)).getMinutes());
            NativeMemoryCacheManager.getInstance().rebuildCache(builder.build());
        }, new ArrayList(dynamicCacheSettings.values()));
    }

    public <T> T getSettingValue(String key) {
        return (T)this.clusterService.getClusterSettings().get(this.getSetting(key));
    }

    private Setting<?> getSetting(String key) {
        if (dynamicCacheSettings.containsKey(key)) {
            return dynamicCacheSettings.get(key);
        }
        if (KNN_CIRCUIT_BREAKER_TRIGGERED.equals(key)) {
            return KNN_CIRCUIT_BREAKER_TRIGGERED_SETTING;
        }
        if (KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE.equals(key)) {
            return KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE_SETTING;
        }
        if (KNN_ALGO_PARAM_INDEX_THREAD_QTY.equals(key)) {
            return KNN_ALGO_PARAM_INDEX_THREAD_QTY_SETTING;
        }
        if (ADVANCED_FILTERED_EXACT_SEARCH_THRESHOLD.equals(key)) {
            return ADVANCED_FILTERED_EXACT_SEARCH_THRESHOLD_SETTING;
        }
        throw new IllegalArgumentException("Cannot find setting by key [" + key + "]");
    }

    public List<Setting<?>> getSettings() {
        List<Setting> settings = Arrays.asList(INDEX_KNN_SPACE_TYPE, INDEX_KNN_ALGO_PARAM_M_SETTING, INDEX_KNN_ALGO_PARAM_EF_CONSTRUCTION_SETTING, INDEX_KNN_ALGO_PARAM_EF_SEARCH_SETTING, KNN_ALGO_PARAM_INDEX_THREAD_QTY_SETTING, KNN_CIRCUIT_BREAKER_TRIGGERED_SETTING, KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE_SETTING, IS_KNN_INDEX_SETTING, MODEL_INDEX_NUMBER_OF_SHARDS_SETTING, MODEL_INDEX_NUMBER_OF_REPLICAS_SETTING, MODEL_CACHE_SIZE_LIMIT_SETTING, ADVANCED_FILTERED_EXACT_SEARCH_THRESHOLD_SETTING);
        return Stream.concat(settings.stream(), dynamicCacheSettings.values().stream()).collect(Collectors.toList());
    }

    public static boolean isKNNPluginEnabled() {
        return (Boolean)KNNSettings.state().getSettingValue(KNN_PLUGIN_ENABLED);
    }

    public static boolean isCircuitBreakerTriggered() {
        return (Boolean)KNNSettings.state().getSettingValue(KNN_CIRCUIT_BREAKER_TRIGGERED);
    }

    public static ByteSizeValue getCircuitBreakerLimit() {
        return (ByteSizeValue)KNNSettings.state().getSettingValue(KNN_MEMORY_CIRCUIT_BREAKER_LIMIT);
    }

    public static double getCircuitBreakerUnsetPercentage() {
        return (Double)KNNSettings.state().getSettingValue(KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE);
    }

    public static Integer getFilteredExactSearchThreshold(String indexName) {
        return KNNSettings.state().clusterService.state().getMetadata().index(indexName).getSettings().getAsInt(ADVANCED_FILTERED_EXACT_SEARCH_THRESHOLD, ADVANCED_FILTERED_EXACT_SEARCH_THRESHOLD_DEFAULT_VALUE);
    }

    public void initialize(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
        this.setSettingsUpdateConsumers();
    }

    public static ByteSizeValue parseknnMemoryCircuitBreakerValue(String sValue, String settingName) {
        settingName = Objects.requireNonNull(settingName);
        if (sValue != null && sValue.endsWith("%")) {
            String percentAsString = sValue.substring(0, sValue.length() - 1);
            try {
                double percent = Double.parseDouble(percentAsString);
                if (percent < 0.0 || percent > 100.0) {
                    throw new OpenSearchParseException("percentage should be in [0-100], got [{}]", new Object[]{percentAsString});
                }
                long physicalMemoryInBytes = osProbe.getTotalPhysicalMemorySize();
                if (physicalMemoryInBytes <= 0L) {
                    throw new IllegalStateException("Physical memory size could not be determined");
                }
                long esJvmSizeInBytes = JvmInfo.jvmInfo().getMem().getHeapMax().getBytes();
                long eligibleMemoryInBytes = physicalMemoryInBytes - esJvmSizeInBytes;
                return new ByteSizeValue((long)(percent / 100.0 * (double)eligibleMemoryInBytes), ByteSizeUnit.BYTES);
            }
            catch (NumberFormatException e) {
                throw new OpenSearchParseException("failed to parse [{}] as a double", (Throwable)e, new Object[]{percentAsString});
            }
        }
        return ByteSizeValue.parseBytesSizeValue((String)sValue, (String)settingName);
    }

    public synchronized void updateCircuitBreakerSettings(boolean flag) {
        final ClusterUpdateSettingsRequest clusterUpdateSettingsRequest = new ClusterUpdateSettingsRequest();
        Settings circuitBreakerSettings = Settings.builder().put(KNN_CIRCUIT_BREAKER_TRIGGERED, flag).build();
        clusterUpdateSettingsRequest.persistentSettings(circuitBreakerSettings);
        this.client.admin().cluster().updateSettings(clusterUpdateSettingsRequest, (ActionListener)new ActionListener<ClusterUpdateSettingsResponse>(){

            public void onResponse(ClusterUpdateSettingsResponse clusterUpdateSettingsResponse) {
                logger.debug("Cluster setting {}, acknowledged: {} ", (Object)clusterUpdateSettingsRequest.persistentSettings(), (Object)clusterUpdateSettingsResponse.isAcknowledged());
            }

            public void onFailure(Exception e) {
                logger.info("Exception while updating circuit breaker setting {} to {}", (Object)clusterUpdateSettingsRequest.persistentSettings(), (Object)e.getMessage());
            }
        });
    }

    public static int getEfSearchParam(String index) {
        return KNNSettings.state().clusterService.state().getMetadata().index(index).getSettings().getAsInt(KNN_ALGO_PARAM_EF_SEARCH, Integer.valueOf(512));
    }

    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public void onIndexModule(IndexModule module) {
        module.addSettingsUpdateConsumer(INDEX_KNN_ALGO_PARAM_EF_SEARCH_SETTING, newVal -> {
            logger.debug("The value of [KNN] setting [{}] changed to [{}]", (Object)KNN_ALGO_PARAM_EF_SEARCH, newVal);
            NativeMemoryCacheManager.getInstance().rebuildCache();
        });
    }

    private static String percentageAsString(Integer percentage) {
        return percentage + "%";
    }

    private static Double percentageAsFraction(Integer percentage) {
        return (double)percentage.intValue() / 100.0;
    }

    static {
        osProbe = OsProbe.getInstance();
        INDEX_KNN_DEFAULT_ALGO_PARAM_M = 16;
        INDEX_KNN_DEFAULT_ALGO_PARAM_EF_SEARCH = 512;
        INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION = 512;
        KNN_DEFAULT_ALGO_PARAM_INDEX_THREAD_QTY = 1;
        KNN_DEFAULT_CIRCUIT_BREAKER_UNSET_PERCENTAGE = 75;
        KNN_DEFAULT_MODEL_CACHE_SIZE_LIMIT_PERCENTAGE = 10;
        KNN_MAX_MODEL_CACHE_SIZE_LIMIT_PERCENTAGE = 25;
        ADVANCED_FILTERED_EXACT_SEARCH_THRESHOLD_DEFAULT_VALUE = -1;
        INDEX_KNN_SPACE_TYPE = Setting.simpleString((String)KNN_SPACE_TYPE, (String)INDEX_KNN_DEFAULT_SPACE_TYPE, (Setting.Validator)new SpaceTypeValidator(), (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.Deprecated});
        INDEX_KNN_ALGO_PARAM_M_SETTING = Setting.intSetting((String)KNN_ALGO_PARAM_M, (int)INDEX_KNN_DEFAULT_ALGO_PARAM_M, (int)2, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.Deprecated});
        INDEX_KNN_ALGO_PARAM_EF_SEARCH_SETTING = Setting.intSetting((String)KNN_ALGO_PARAM_EF_SEARCH, (int)INDEX_KNN_DEFAULT_ALGO_PARAM_EF_SEARCH, (int)2, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.Dynamic});
        INDEX_KNN_ALGO_PARAM_EF_CONSTRUCTION_SETTING = Setting.intSetting((String)KNN_ALGO_PARAM_EF_CONSTRUCTION, (int)INDEX_KNN_DEFAULT_ALGO_PARAM_EF_CONSTRUCTION, (int)2, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.Deprecated});
        MODEL_INDEX_NUMBER_OF_SHARDS_SETTING = Setting.intSetting((String)MODEL_INDEX_NUMBER_OF_SHARDS, (int)1, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        MODEL_INDEX_NUMBER_OF_REPLICAS_SETTING = Setting.intSetting((String)MODEL_INDEX_NUMBER_OF_REPLICAS, (int)1, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        ADVANCED_FILTERED_EXACT_SEARCH_THRESHOLD_SETTING = Setting.intSetting((String)ADVANCED_FILTERED_EXACT_SEARCH_THRESHOLD, (int)ADVANCED_FILTERED_EXACT_SEARCH_THRESHOLD_DEFAULT_VALUE, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.Dynamic});
        MODEL_CACHE_SIZE_LIMIT_SETTING = new Setting(MODEL_CACHE_SIZE_LIMIT, KNNSettings.percentageAsString(KNN_DEFAULT_MODEL_CACHE_SIZE_LIMIT_PERCENTAGE), s -> {
            ByteSizeValue userDefinedLimit = MemorySizeValue.parseBytesSizeValueOrHeapRatio((String)s, (String)MODEL_CACHE_SIZE_LIMIT);
            ByteSizeValue jvmHeapSize = JvmInfo.jvmInfo().getMem().getHeapMax();
            if (userDefinedLimit.getKbFrac() / jvmHeapSize.getKbFrac() > KNNSettings.percentageAsFraction(KNN_MAX_MODEL_CACHE_SIZE_LIMIT_PERCENTAGE)) {
                throw new OpenSearchParseException("{} ({} KB) cannot exceed {}% of the heap ({} KB).", new Object[]{MODEL_CACHE_SIZE_LIMIT, userDefinedLimit.getKb(), KNN_MAX_MODEL_CACHE_SIZE_LIMIT_PERCENTAGE, jvmHeapSize.getKb()});
            }
            return userDefinedLimit;
        }, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        IS_KNN_INDEX_SETTING = Setting.boolSetting((String)KNN_INDEX, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope});
        KNN_ALGO_PARAM_INDEX_THREAD_QTY_SETTING = Setting.intSetting((String)KNN_ALGO_PARAM_INDEX_THREAD_QTY, (int)KNN_DEFAULT_ALGO_PARAM_INDEX_THREAD_QTY, (int)1, (int)32, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        KNN_CIRCUIT_BREAKER_TRIGGERED_SETTING = Setting.boolSetting((String)KNN_CIRCUIT_BREAKER_TRIGGERED, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE_SETTING = Setting.doubleSetting((String)KNN_CIRCUIT_BREAKER_UNSET_PERCENTAGE, (double)KNN_DEFAULT_CIRCUIT_BREAKER_UNSET_PERCENTAGE.intValue(), (double)0.0, (double)100.0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        dynamicCacheSettings = new HashMap<String, Setting<?>>(){
            {
                this.put(KNNSettings.KNN_PLUGIN_ENABLED, Setting.boolSetting((String)KNNSettings.KNN_PLUGIN_ENABLED, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
                this.put(KNNSettings.KNN_MEMORY_CIRCUIT_BREAKER_ENABLED, Setting.boolSetting((String)KNNSettings.KNN_MEMORY_CIRCUIT_BREAKER_ENABLED, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
                this.put(KNNSettings.KNN_MEMORY_CIRCUIT_BREAKER_LIMIT, new Setting(KNNSettings.KNN_MEMORY_CIRCUIT_BREAKER_LIMIT, KNNSettings.KNN_DEFAULT_MEMORY_CIRCUIT_BREAKER_LIMIT, s -> KNNSettings.parseknnMemoryCircuitBreakerValue(s, KNNSettings.KNN_MEMORY_CIRCUIT_BREAKER_LIMIT), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
                this.put(KNNSettings.KNN_CACHE_ITEM_EXPIRY_ENABLED, Setting.boolSetting((String)KNNSettings.KNN_CACHE_ITEM_EXPIRY_ENABLED, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
                this.put(KNNSettings.KNN_CACHE_ITEM_EXPIRY_TIME_MINUTES, Setting.positiveTimeSetting((String)KNNSettings.KNN_CACHE_ITEM_EXPIRY_TIME_MINUTES, (TimeValue)TimeValue.timeValueHours((long)3L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
            }
        };
    }

    static class SpaceTypeValidator
    implements Setting.Validator<String> {
        SpaceTypeValidator() {
        }

        public void validate(String value) {
            try {
                SpaceType.getSpace(value);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidParameterException(ex.getMessage());
            }
        }
    }
}

