/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.resthandler;

import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.indexstatemanagement.model.ChangePolicy;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.changepolicy.ChangePolicyAction;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.changepolicy.ChangePolicyRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/resthandler/RestChangePolicyAction;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "getName", "", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "routes", "Lorg/opensearch/rest/RestHandler$Route;", "Companion", "opensearch-index-management"})
public final class RestChangePolicyAction
extends BaseRestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String CHANGE_POLICY_BASE_URI = "/_plugins/_ism/change_policy";
    @NotNull
    public static final String LEGACY_CHANGE_POLICY_BASE_URI = "/_opendistro/_ism/change_policy";
    @NotNull
    public static final String INDEX_NOT_MANAGED = "This index is not being managed";
    @NotNull
    public static final String INDEX_IN_TRANSITION = "Cannot change policy while transitioning to new state";

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.POST, CHANGE_POLICY_BASE_URI, RestRequest.Method.POST, LEGACY_CHANGE_POLICY_BASE_URI), new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_ism/change_policy/{index}", RestRequest.Method.POST, "/_opendistro/_ism/change_policy/{index}")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getName() {
        return "change_policy_action";
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Object[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        if (indices == null || indices.length == 0) {
            throw new IllegalArgumentException("Missing index");
        }
        String indexType = request.param("type", "_default");
        XContentParser xcp = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
        ChangePolicy changePolicy = ChangePolicy.Companion.parse(xcp);
        List list = ArraysKt.toList((Object[])indices);
        Intrinsics.checkNotNullExpressionValue((Object)indexType, (String)"indexType");
        ChangePolicyRequest changePolicyRequest = new ChangePolicyRequest(list, changePolicy, indexType);
        return arg_0 -> RestChangePolicyAction.prepareRequest$lambda$0(client, changePolicyRequest, arg_0);
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, ChangePolicyRequest $changePolicyRequest, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)((Object)$changePolicyRequest), (String)"$changePolicyRequest");
        $client.execute((ActionType)ChangePolicyAction.Companion.getINSTANCE(), (ActionRequest)$changePolicyRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/resthandler/RestChangePolicyAction$Companion;", "", "()V", "CHANGE_POLICY_BASE_URI", "", "INDEX_IN_TRANSITION", "INDEX_NOT_MANAGED", "LEGACY_CHANGE_POLICY_BASE_URI", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

