/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkAclsResponse;
import software.amazon.awssdk.services.ec2.model.NetworkAcl;

public class DescribeNetworkAclsIterable
implements SdkIterable<DescribeNetworkAclsResponse> {
    private final Ec2Client client;
    private final DescribeNetworkAclsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeNetworkAclsIterable(Ec2Client client, DescribeNetworkAclsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeNetworkAclsResponseFetcher();
    }

    public Iterator<DescribeNetworkAclsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NetworkAcl> networkAcls() {
        Function<DescribeNetworkAclsResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkAcls() != null) {
                return response.networkAcls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeNetworkAclsResponseFetcher
    implements SyncPageFetcher<DescribeNetworkAclsResponse> {
        private DescribeNetworkAclsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNetworkAclsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeNetworkAclsResponse nextPage(DescribeNetworkAclsResponse previousPage) {
            if (previousPage == null) {
                return DescribeNetworkAclsIterable.this.client.describeNetworkAcls(DescribeNetworkAclsIterable.this.firstRequest);
            }
            return DescribeNetworkAclsIterable.this.client.describeNetworkAcls((DescribeNetworkAclsRequest)((Object)DescribeNetworkAclsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

