/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IntegrateServices;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFlowLogsIntegrationTemplateRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, GetFlowLogsIntegrationTemplateRequest> {
    private static final SdkField<String> FLOW_LOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowLogId").getter(GetFlowLogsIntegrationTemplateRequest.getter(GetFlowLogsIntegrationTemplateRequest::flowLogId)).setter(GetFlowLogsIntegrationTemplateRequest.setter(Builder::flowLogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogId").unmarshallLocationName("FlowLogId").build()}).build();
    private static final SdkField<String> CONFIG_DELIVERY_S3_DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigDeliveryS3DestinationArn").getter(GetFlowLogsIntegrationTemplateRequest.getter(GetFlowLogsIntegrationTemplateRequest::configDeliveryS3DestinationArn)).setter(GetFlowLogsIntegrationTemplateRequest.setter(Builder::configDeliveryS3DestinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigDeliveryS3DestinationArn").unmarshallLocationName("ConfigDeliveryS3DestinationArn").build()}).build();
    private static final SdkField<IntegrateServices> INTEGRATE_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IntegrateServices").getter(GetFlowLogsIntegrationTemplateRequest.getter(GetFlowLogsIntegrationTemplateRequest::integrateServices)).setter(GetFlowLogsIntegrationTemplateRequest.setter(Builder::integrateServices)).constructor(IntegrateServices::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrateService").unmarshallLocationName("IntegrateService").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_LOG_ID_FIELD, CONFIG_DELIVERY_S3_DESTINATION_ARN_FIELD, INTEGRATE_SERVICES_FIELD));
    private final String flowLogId;
    private final String configDeliveryS3DestinationArn;
    private final IntegrateServices integrateServices;

    private GetFlowLogsIntegrationTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.flowLogId = builder.flowLogId;
        this.configDeliveryS3DestinationArn = builder.configDeliveryS3DestinationArn;
        this.integrateServices = builder.integrateServices;
    }

    public final String flowLogId() {
        return this.flowLogId;
    }

    public final String configDeliveryS3DestinationArn() {
        return this.configDeliveryS3DestinationArn;
    }

    public final IntegrateServices integrateServices() {
        return this.integrateServices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowLogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configDeliveryS3DestinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrateServices());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFlowLogsIntegrationTemplateRequest)) {
            return false;
        }
        GetFlowLogsIntegrationTemplateRequest other = (GetFlowLogsIntegrationTemplateRequest)((Object)obj);
        return Objects.equals(this.flowLogId(), other.flowLogId()) && Objects.equals(this.configDeliveryS3DestinationArn(), other.configDeliveryS3DestinationArn()) && Objects.equals(this.integrateServices(), other.integrateServices());
    }

    public final String toString() {
        return ToString.builder((String)"GetFlowLogsIntegrationTemplateRequest").add("FlowLogId", (Object)this.flowLogId()).add("ConfigDeliveryS3DestinationArn", (Object)this.configDeliveryS3DestinationArn()).add("IntegrateServices", (Object)this.integrateServices()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowLogId": {
                return Optional.ofNullable(clazz.cast(this.flowLogId()));
            }
            case "ConfigDeliveryS3DestinationArn": {
                return Optional.ofNullable(clazz.cast(this.configDeliveryS3DestinationArn()));
            }
            case "IntegrateServices": {
                return Optional.ofNullable(clazz.cast(this.integrateServices()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFlowLogsIntegrationTemplateRequest, T> g) {
        return obj -> g.apply((GetFlowLogsIntegrationTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String flowLogId;
        private String configDeliveryS3DestinationArn;
        private IntegrateServices integrateServices;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFlowLogsIntegrationTemplateRequest model) {
            super(model);
            this.flowLogId(model.flowLogId);
            this.configDeliveryS3DestinationArn(model.configDeliveryS3DestinationArn);
            this.integrateServices(model.integrateServices);
        }

        public final String getFlowLogId() {
            return this.flowLogId;
        }

        public final void setFlowLogId(String flowLogId) {
            this.flowLogId = flowLogId;
        }

        @Override
        public final Builder flowLogId(String flowLogId) {
            this.flowLogId = flowLogId;
            return this;
        }

        public final String getConfigDeliveryS3DestinationArn() {
            return this.configDeliveryS3DestinationArn;
        }

        public final void setConfigDeliveryS3DestinationArn(String configDeliveryS3DestinationArn) {
            this.configDeliveryS3DestinationArn = configDeliveryS3DestinationArn;
        }

        @Override
        public final Builder configDeliveryS3DestinationArn(String configDeliveryS3DestinationArn) {
            this.configDeliveryS3DestinationArn = configDeliveryS3DestinationArn;
            return this;
        }

        public final IntegrateServices.Builder getIntegrateServices() {
            return this.integrateServices != null ? this.integrateServices.toBuilder() : null;
        }

        public final void setIntegrateServices(IntegrateServices.BuilderImpl integrateServices) {
            this.integrateServices = integrateServices != null ? integrateServices.build() : null;
        }

        @Override
        public final Builder integrateServices(IntegrateServices integrateServices) {
            this.integrateServices = integrateServices;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFlowLogsIntegrationTemplateRequest build() {
            return new GetFlowLogsIntegrationTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFlowLogsIntegrationTemplateRequest> {
        public Builder flowLogId(String var1);

        public Builder configDeliveryS3DestinationArn(String var1);

        public Builder integrateServices(IntegrateServices var1);

        default public Builder integrateServices(Consumer<IntegrateServices.Builder> integrateServices) {
            return this.integrateServices((IntegrateServices)((IntegrateServices.Builder)IntegrateServices.builder().applyMutation(integrateServices)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

