/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EbsOptimizedInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EbsOptimizedInfo> {
    private static final SdkField<Integer> BASELINE_BANDWIDTH_IN_MBPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BaselineBandwidthInMbps").getter(EbsOptimizedInfo.getter(EbsOptimizedInfo::baselineBandwidthInMbps)).setter(EbsOptimizedInfo.setter(Builder::baselineBandwidthInMbps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineBandwidthInMbps").unmarshallLocationName("baselineBandwidthInMbps").build()}).build();
    private static final SdkField<Double> BASELINE_THROUGHPUT_IN_M_BPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("BaselineThroughputInMBps").getter(EbsOptimizedInfo.getter(EbsOptimizedInfo::baselineThroughputInMBps)).setter(EbsOptimizedInfo.setter(Builder::baselineThroughputInMBps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineThroughputInMBps").unmarshallLocationName("baselineThroughputInMBps").build()}).build();
    private static final SdkField<Integer> BASELINE_IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BaselineIops").getter(EbsOptimizedInfo.getter(EbsOptimizedInfo::baselineIops)).setter(EbsOptimizedInfo.setter(Builder::baselineIops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineIops").unmarshallLocationName("baselineIops").build()}).build();
    private static final SdkField<Integer> MAXIMUM_BANDWIDTH_IN_MBPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumBandwidthInMbps").getter(EbsOptimizedInfo.getter(EbsOptimizedInfo::maximumBandwidthInMbps)).setter(EbsOptimizedInfo.setter(Builder::maximumBandwidthInMbps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBandwidthInMbps").unmarshallLocationName("maximumBandwidthInMbps").build()}).build();
    private static final SdkField<Double> MAXIMUM_THROUGHPUT_IN_M_BPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaximumThroughputInMBps").getter(EbsOptimizedInfo.getter(EbsOptimizedInfo::maximumThroughputInMBps)).setter(EbsOptimizedInfo.setter(Builder::maximumThroughputInMBps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumThroughputInMBps").unmarshallLocationName("maximumThroughputInMBps").build()}).build();
    private static final SdkField<Integer> MAXIMUM_IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumIops").getter(EbsOptimizedInfo.getter(EbsOptimizedInfo::maximumIops)).setter(EbsOptimizedInfo.setter(Builder::maximumIops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumIops").unmarshallLocationName("maximumIops").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_BANDWIDTH_IN_MBPS_FIELD, BASELINE_THROUGHPUT_IN_M_BPS_FIELD, BASELINE_IOPS_FIELD, MAXIMUM_BANDWIDTH_IN_MBPS_FIELD, MAXIMUM_THROUGHPUT_IN_M_BPS_FIELD, MAXIMUM_IOPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer baselineBandwidthInMbps;
    private final Double baselineThroughputInMBps;
    private final Integer baselineIops;
    private final Integer maximumBandwidthInMbps;
    private final Double maximumThroughputInMBps;
    private final Integer maximumIops;

    private EbsOptimizedInfo(BuilderImpl builder) {
        this.baselineBandwidthInMbps = builder.baselineBandwidthInMbps;
        this.baselineThroughputInMBps = builder.baselineThroughputInMBps;
        this.baselineIops = builder.baselineIops;
        this.maximumBandwidthInMbps = builder.maximumBandwidthInMbps;
        this.maximumThroughputInMBps = builder.maximumThroughputInMBps;
        this.maximumIops = builder.maximumIops;
    }

    public final Integer baselineBandwidthInMbps() {
        return this.baselineBandwidthInMbps;
    }

    public final Double baselineThroughputInMBps() {
        return this.baselineThroughputInMBps;
    }

    public final Integer baselineIops() {
        return this.baselineIops;
    }

    public final Integer maximumBandwidthInMbps() {
        return this.maximumBandwidthInMbps;
    }

    public final Double maximumThroughputInMBps() {
        return this.maximumThroughputInMBps;
    }

    public final Integer maximumIops() {
        return this.maximumIops;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineBandwidthInMbps());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineThroughputInMBps());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineIops());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBandwidthInMbps());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumThroughputInMBps());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumIops());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsOptimizedInfo)) {
            return false;
        }
        EbsOptimizedInfo other = (EbsOptimizedInfo)obj;
        return Objects.equals(this.baselineBandwidthInMbps(), other.baselineBandwidthInMbps()) && Objects.equals(this.baselineThroughputInMBps(), other.baselineThroughputInMBps()) && Objects.equals(this.baselineIops(), other.baselineIops()) && Objects.equals(this.maximumBandwidthInMbps(), other.maximumBandwidthInMbps()) && Objects.equals(this.maximumThroughputInMBps(), other.maximumThroughputInMBps()) && Objects.equals(this.maximumIops(), other.maximumIops());
    }

    public final String toString() {
        return ToString.builder((String)"EbsOptimizedInfo").add("BaselineBandwidthInMbps", (Object)this.baselineBandwidthInMbps()).add("BaselineThroughputInMBps", (Object)this.baselineThroughputInMBps()).add("BaselineIops", (Object)this.baselineIops()).add("MaximumBandwidthInMbps", (Object)this.maximumBandwidthInMbps()).add("MaximumThroughputInMBps", (Object)this.maximumThroughputInMBps()).add("MaximumIops", (Object)this.maximumIops()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaselineBandwidthInMbps": {
                return Optional.ofNullable(clazz.cast(this.baselineBandwidthInMbps()));
            }
            case "BaselineThroughputInMBps": {
                return Optional.ofNullable(clazz.cast(this.baselineThroughputInMBps()));
            }
            case "BaselineIops": {
                return Optional.ofNullable(clazz.cast(this.baselineIops()));
            }
            case "MaximumBandwidthInMbps": {
                return Optional.ofNullable(clazz.cast(this.maximumBandwidthInMbps()));
            }
            case "MaximumThroughputInMBps": {
                return Optional.ofNullable(clazz.cast(this.maximumThroughputInMBps()));
            }
            case "MaximumIops": {
                return Optional.ofNullable(clazz.cast(this.maximumIops()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsOptimizedInfo, T> g) {
        return obj -> g.apply((EbsOptimizedInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer baselineBandwidthInMbps;
        private Double baselineThroughputInMBps;
        private Integer baselineIops;
        private Integer maximumBandwidthInMbps;
        private Double maximumThroughputInMBps;
        private Integer maximumIops;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsOptimizedInfo model) {
            this.baselineBandwidthInMbps(model.baselineBandwidthInMbps);
            this.baselineThroughputInMBps(model.baselineThroughputInMBps);
            this.baselineIops(model.baselineIops);
            this.maximumBandwidthInMbps(model.maximumBandwidthInMbps);
            this.maximumThroughputInMBps(model.maximumThroughputInMBps);
            this.maximumIops(model.maximumIops);
        }

        public final Integer getBaselineBandwidthInMbps() {
            return this.baselineBandwidthInMbps;
        }

        public final void setBaselineBandwidthInMbps(Integer baselineBandwidthInMbps) {
            this.baselineBandwidthInMbps = baselineBandwidthInMbps;
        }

        @Override
        public final Builder baselineBandwidthInMbps(Integer baselineBandwidthInMbps) {
            this.baselineBandwidthInMbps = baselineBandwidthInMbps;
            return this;
        }

        public final Double getBaselineThroughputInMBps() {
            return this.baselineThroughputInMBps;
        }

        public final void setBaselineThroughputInMBps(Double baselineThroughputInMBps) {
            this.baselineThroughputInMBps = baselineThroughputInMBps;
        }

        @Override
        public final Builder baselineThroughputInMBps(Double baselineThroughputInMBps) {
            this.baselineThroughputInMBps = baselineThroughputInMBps;
            return this;
        }

        public final Integer getBaselineIops() {
            return this.baselineIops;
        }

        public final void setBaselineIops(Integer baselineIops) {
            this.baselineIops = baselineIops;
        }

        @Override
        public final Builder baselineIops(Integer baselineIops) {
            this.baselineIops = baselineIops;
            return this;
        }

        public final Integer getMaximumBandwidthInMbps() {
            return this.maximumBandwidthInMbps;
        }

        public final void setMaximumBandwidthInMbps(Integer maximumBandwidthInMbps) {
            this.maximumBandwidthInMbps = maximumBandwidthInMbps;
        }

        @Override
        public final Builder maximumBandwidthInMbps(Integer maximumBandwidthInMbps) {
            this.maximumBandwidthInMbps = maximumBandwidthInMbps;
            return this;
        }

        public final Double getMaximumThroughputInMBps() {
            return this.maximumThroughputInMBps;
        }

        public final void setMaximumThroughputInMBps(Double maximumThroughputInMBps) {
            this.maximumThroughputInMBps = maximumThroughputInMBps;
        }

        @Override
        public final Builder maximumThroughputInMBps(Double maximumThroughputInMBps) {
            this.maximumThroughputInMBps = maximumThroughputInMBps;
            return this;
        }

        public final Integer getMaximumIops() {
            return this.maximumIops;
        }

        public final void setMaximumIops(Integer maximumIops) {
            this.maximumIops = maximumIops;
        }

        @Override
        public final Builder maximumIops(Integer maximumIops) {
            this.maximumIops = maximumIops;
            return this;
        }

        public EbsOptimizedInfo build() {
            return new EbsOptimizedInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EbsOptimizedInfo> {
        public Builder baselineBandwidthInMbps(Integer var1);

        public Builder baselineThroughputInMBps(Double var1);

        public Builder baselineIops(Integer var1);

        public Builder maximumBandwidthInMbps(Integer var1);

        public Builder maximumThroughputInMBps(Double var1);

        public Builder maximumIops(Integer var1);
    }
}

