"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MOCK_DATA = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const mockChime = {
  name: 'Chime test channel',
  description: 'test description',
  config_type: 'chime',
  is_enabled: true,
  chime: {
    url: 'https://chimehook'
  },
  config_id: 'test-chime',
  created_time_ms: 1622670451891,
  last_updated_time_ms: 1622670451891
};
const mockSlack = {
  name: 'Slack test channel',
  description: 'test description',
  config_type: 'slack',
  is_enabled: false,
  slack: {
    url: 'https://chimehook'
  },
  config_id: 'test-slack',
  created_time_ms: 1622670451891,
  last_updated_time_ms: 1622670451891
};
const mockEmail = {
  name: 'Email test channel',
  description: 'test description',
  config_type: 'email',
  is_enabled: true,
  email: {
    email_account_id: 'dj8etXkBCzVy9Vy-nsiL',
    recipient_list: [{
      recipient: 'custom@email.com'
    }, {
      recipient: 'email@test.com'
    }, {
      recipient: 'test@email.com'
    }],
    email_group_id_list: ['1l8hq3kB0XwiBlEbanSo', 'dz8etXkBCzVy9Vy-0sgh', 'eD8ktXkBCzVy9Vy-A8j-', '1V8gq3kB0XwiBlEbAXSI', 'dD_8tHkBCzVy9Vy-5si0', '52XGr3kBqFjWrmvL43mv'],
    email_account_name: 'name1',
    email_group_id_map: {
      '1l8hq3kB0XwiBlEbanSo': 'name1',
      'dz8etXkBCzVy9Vy-0sgh': 'name2',
      'eD8ktXkBCzVy9Vy-A8j-': 'name3',
      '1V8gq3kB0XwiBlEbAXSI': 'name4',
      'dD_8tHkBCzVy9Vy-5si0': 'name5',
      '52XGr3kBqFjWrmvL43mv': 'name6'
    },
    invalid_ids: [],
    sender_type: 'smtp_account'
  },
  config_id: 'DMG3zXkBPa6YFxmVfNmm',
  created_time_ms: 1622654024861,
  last_updated_time_ms: 1622656665674
};
const mockEmailWithSES = {
  name: 'Email test channel',
  description: 'test description',
  config_type: 'email',
  is_enabled: true,
  email: {
    email_account_id: 'dj8etXkBCzVy9Vy-nsiL',
    recipient_list: [{
      recipient: 'custom@email.com'
    }, {
      recipient: 'email@test.com'
    }, {
      recipient: 'test@email.com'
    }],
    email_group_id_list: ['1y8ud3xO0KjvOyRonaFb', 'qm8rgKxOPmIl9Il-0ftu', 'rQ8xgKxOPmIl9Il-N8w-', '1I8td3xO0KjvOyRoNKFV', 'qQ_8gUxOPmIl9Il-5fv0', '52KTe3xOdSwJeziY43zi'],
    email_account_name: 'name1',
    email_group_id_map: {
      '1y8ud3xO0KjvOyRonaFb': 'name1',
      'qm8rgKxOPmIl9Il-0ftu': 'name2',
      'rQ8xgKxOPmIl9Il-N8w-': 'name3',
      '1I8td3xO0KjvOyRoNKFV': 'name4',
      'qQ_8gUxOPmIl9Il-5fv0': 'name5',
      '52KTe3xOdSwJeziY43zi': 'name6'
    },
    invalid_ids: ['52KTe3xOdSwJeziY43zi'],
    sender_type: 'ses_account'
  },
  config_id: 'QZT3mKxOCn6LSkzIsAzz',
  created_time_ms: 1622654024861,
  last_updated_time_ms: 1622656665674
};
const mockWebhook = {
  name: 'Webhook test channel',
  description: 'test description',
  config_type: 'webhook',
  is_enabled: true,
  webhook: {
    url: 'https://host:23/path?key1=%23%404&key2=&key3=value3',
    header_params: {
      key1: 'value1',
      key2: 'value2',
      key3: '',
      key4: 'value4',
      key5: 'value5',
      key6: 'value6'
    },
    method: 'POST'
  },
  config_id: '7mUjsHkBqFjWrmvLc3nl',
  created_time_ms: 1622157784037,
  last_updated_time_ms: 1622581084050
};
const mockSNS = {
  name: 'SNS test channel',
  description: 'test description',
  config_type: 'sns',
  is_enabled: true,
  sns: {
    topic_arn: 'arn:aws:sns:us-west-2:012345678912:notifications-test',
    role_arn: 'arn:aws:iam::012345678912:role/NotificationsSNSRole'
  },
  config_id: 'erCDYHsBUMRLC5PZXfPN',
  created_time_ms: 1622157784037,
  last_updated_time_ms: 1622581084050
};
const mockSender = {
  name: 'test-sender',
  description: 'test description',
  config_id: '72UysHkBqFjWrmvLFXkB',
  created_time_ms: 1622158742784,
  last_updated_time_ms: 1622158742784,
  smtp_account: {
    host: 'example.com',
    port: '23',
    method: 'start_tls',
    from_address: 'sample@email.com'
  }
};
const mockSESSender = {
  name: 'test-ses-sender',
  description: 'test description',
  config_id: '72HlfUxOdSwJeziYSKxO',
  created_time_ms: 1622158742784,
  last_updated_time_ms: 1622158742784,
  ses_account: {
    from_address: 'sample@email.com',
    region: 'us-west-2',
    role_arn: 'arn:aws:iam::012345678912:role/TestNotificationsSESRole'
  }
};
const mockRecipientGroup = {
  name: 'Test recipient group',
  description: 'test description',
  config_id: '72UysHkBqVjWrmvLFXkB',
  created_time_ms: 1622158742784,
  last_updated_time_ms: 1622158742784,
  email_group: {
    recipient_list: [{
      recipient: 'test1@email.com'
    }, {
      recipient: 'test2@email.com'
    }, {
      recipient: 'test3@email.com'
    }, {
      recipient: 'test4@email.com'
    }, {
      recipient: 'test5@email.com'
    }, {
      recipient: 'test6@email.com'
    }]
  }
};
const MOCK_DATA = {
  channels: {
    items: [mockChime, mockSlack, mockEmail, mockEmailWithSES, mockWebhook, mockSNS],
    total: 6
  },
  chime: mockChime,
  slack: mockSlack,
  email: mockEmail,
  emailWithSES: mockEmailWithSES,
  webhook: mockWebhook,
  sns: mockSNS,
  sender: mockSender,
  sesSender: mockSESSender,
  senders: {
    items: [mockSender],
    total: 1
  },
  sesSenders: {
    items: [mockSESSender],
    total: 1
  },
  recipientGroup: mockRecipientGroup,
  recipientGroups: {
    items: [mockRecipientGroup],
    total: 1
  }
};
exports.MOCK_DATA = MOCK_DATA;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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