/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore.transfer;

import com.jcraft.jzlib.JZlib;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.zip.CRC32;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.IndexInput;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.CheckedTriFunction;
import org.opensearch.common.SetOnce;
import org.opensearch.common.StreamContext;
import org.opensearch.common.blobstore.stream.write.WriteContext;
import org.opensearch.common.blobstore.stream.write.WritePriority;
import org.opensearch.common.blobstore.transfer.stream.OffsetRangeInputStream;
import org.opensearch.common.blobstore.transfer.stream.ResettableCheckedInputStream;
import org.opensearch.common.io.InputStreamContainer;
import org.opensearch.common.util.ByteUtils;

public class RemoteTransferContainer
implements Closeable {
    private int numberOfParts;
    private long partSize;
    private long lastPartSize;
    private final long contentLength;
    private final SetOnce<InputStream[]> inputStreams = new SetOnce();
    private final String fileName;
    private final String remoteFileName;
    private final boolean failTransferIfFileExists;
    private final WritePriority writePriority;
    private final long expectedChecksum;
    private final OffsetRangeInputStreamSupplier offsetRangeInputStreamSupplier;
    private final boolean isRemoteDataIntegritySupported;
    private static final Logger log = LogManager.getLogger(RemoteTransferContainer.class);

    public RemoteTransferContainer(String fileName, String remoteFileName, long contentLength, boolean failTransferIfFileExists, WritePriority writePriority, OffsetRangeInputStreamSupplier offsetRangeInputStreamSupplier, long expectedChecksum, boolean isRemoteDataIntegritySupported) {
        this.fileName = fileName;
        this.remoteFileName = remoteFileName;
        this.contentLength = contentLength;
        this.failTransferIfFileExists = failTransferIfFileExists;
        this.writePriority = writePriority;
        this.offsetRangeInputStreamSupplier = offsetRangeInputStreamSupplier;
        this.expectedChecksum = expectedChecksum;
        this.isRemoteDataIntegritySupported = isRemoteDataIntegritySupported;
    }

    public WriteContext createWriteContext() {
        return new WriteContext(this.remoteFileName, this::supplyStreamContext, this.contentLength, this.failTransferIfFileExists, this.writePriority, (CheckedConsumer<Boolean, IOException>)((CheckedConsumer)this::finalizeUpload), this.isRemoteDataIntegrityCheckPossible(), this.isRemoteDataIntegrityCheckPossible() ? Long.valueOf(this.expectedChecksum) : null);
    }

    StreamContext supplyStreamContext(long partSize) {
        try {
            return this.openMultipartStreams(partSize);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private StreamContext openMultipartStreams(long partSize) throws IOException {
        if (this.inputStreams.get() != null) {
            throw new IOException("Multi-part streams are already created.");
        }
        this.partSize = partSize;
        this.lastPartSize = this.contentLength % partSize != 0L ? this.contentLength % partSize : partSize;
        this.numberOfParts = (int)(this.contentLength % partSize == 0L ? this.contentLength / partSize : this.contentLength / partSize + 1L);
        InputStream[] streams = new InputStream[this.numberOfParts];
        this.inputStreams.set((Object)streams);
        return new StreamContext(this.getTransferPartStreamSupplier(), partSize, this.lastPartSize, this.numberOfParts);
    }

    private CheckedTriFunction<Integer, Long, Long, InputStreamContainer, IOException> getTransferPartStreamSupplier() {
        return (partNo, size, position) -> {
            assert (this.inputStreams.get() != null) : "expected inputStreams to be initialised";
            return this.getMultipartStreamSupplier((int)partNo, (long)size, (long)position).get();
        };
    }

    private LocalStreamSupplier<InputStreamContainer> getMultipartStreamSupplier(int streamIdx, long size, long position) {
        return () -> {
            try {
                OffsetRangeInputStream offsetRangeInputStream = this.offsetRangeInputStreamSupplier.get(size, position);
                InputStream inputStream = !this.isRemoteDataIntegrityCheckPossible() ? new ResettableCheckedInputStream(offsetRangeInputStream, this.fileName) : offsetRangeInputStream;
                Objects.requireNonNull((InputStream[])this.inputStreams.get())[streamIdx] = inputStream;
                return new InputStreamContainer(inputStream, size, position);
            }
            catch (IOException e) {
                log.error("Failed to create input stream", (Throwable)e);
                throw e;
            }
        };
    }

    private boolean isRemoteDataIntegrityCheckPossible() {
        return this.isRemoteDataIntegritySupported;
    }

    private void finalizeUpload(boolean uploadSuccessful) throws IOException {
        long actualChecksum;
        if (this.isRemoteDataIntegrityCheckPossible()) {
            return;
        }
        if (uploadSuccessful && (actualChecksum = this.getActualChecksum()) != this.expectedChecksum) {
            throw new CorruptIndexException("Data integrity check done after upload for file " + this.fileName + " failed, actual checksum: " + actualChecksum + ", expected checksum: " + this.expectedChecksum, this.fileName);
        }
    }

    public long getContentLength() {
        return this.contentLength;
    }

    private long getInputStreamChecksum(InputStream inputStream) {
        assert (inputStream instanceof ResettableCheckedInputStream) : "expected passed inputStream to be instance of ResettableCheckedInputStream";
        return ((ResettableCheckedInputStream)inputStream).getChecksum();
    }

    private long getActualChecksum() {
        InputStream[] currentInputStreams = Objects.requireNonNull((InputStream[])this.inputStreams.get());
        long checksum = this.getInputStreamChecksum(currentInputStreams[0]);
        for (int checkSumIdx = 1; checkSumIdx < Objects.requireNonNull((InputStream[])this.inputStreams.get()).length - 1; ++checkSumIdx) {
            checksum = JZlib.crc32_combine((long)checksum, (long)this.getInputStreamChecksum(currentInputStreams[checkSumIdx]), (long)this.partSize);
        }
        if (this.numberOfParts > 1) {
            checksum = JZlib.crc32_combine((long)checksum, (long)this.getInputStreamChecksum(currentInputStreams[this.numberOfParts - 1]), (long)this.lastPartSize);
        }
        return checksum;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStreams.get() == null) {
            log.warn("Input streams cannot be closed since they are not yet set for multi stream upload");
            return;
        }
        boolean closeStreamException = false;
        for (InputStream is : Objects.requireNonNull((InputStream[])this.inputStreams.get())) {
            try {
                if (is == null) continue;
                is.close();
            }
            catch (IOException ex) {
                closeStreamException = true;
                log.error("Multipart stream failed to close ", (Throwable)ex);
            }
        }
        if (closeStreamException) {
            throw new IOException("Closure of some of the multi-part streams failed.");
        }
    }

    public static long checksumOfChecksum(IndexInput indexInput, int checksumBytesLength) throws IOException {
        long storedChecksum = CodecUtil.retrieveChecksum((IndexInput)indexInput);
        CRC32 checksumOfChecksum = new CRC32();
        checksumOfChecksum.update(ByteUtils.toByteArrayBE(storedChecksum));
        return JZlib.crc32_combine((long)storedChecksum, (long)checksumOfChecksum.getValue(), (long)checksumBytesLength);
    }

    static interface LocalStreamSupplier<Stream> {
        public Stream get() throws IOException;
    }

    public static interface OffsetRangeInputStreamSupplier {
        public OffsetRangeInputStream get(long var1, long var3) throws IOException;
    }
}

