/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.health;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeReadRequest;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.common.Priority;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class ClusterHealthRequest
extends ClusterManagerNodeReadRequest<ClusterHealthRequest>
implements IndicesRequest.Replaceable {
    private String[] indices;
    private String awarenessAttribute;
    private IndicesOptions indicesOptions = IndicesOptions.lenientExpandHidden();
    private TimeValue timeout = new TimeValue(30L, TimeUnit.SECONDS);
    private ClusterHealthStatus waitForStatus;
    private boolean waitForNoRelocatingShards = false;
    private boolean waitForNoInitializingShards = false;
    private ActiveShardCount waitForActiveShards = ActiveShardCount.NONE;
    private String waitForNodes = "";
    private Priority waitForEvents = null;
    private boolean ensureNodeWeighedIn = false;
    private Level level = Level.CLUSTER;

    public ClusterHealthRequest() {
    }

    public ClusterHealthRequest(String ... indices) {
        this.indices = indices;
    }

    public ClusterHealthRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.timeout = in.readTimeValue();
        if (in.readBoolean()) {
            this.waitForStatus = ClusterHealthStatus.fromValue(in.readByte());
        }
        this.waitForNoRelocatingShards = in.readBoolean();
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
        this.waitForNodes = in.readString();
        if (in.readBoolean()) {
            this.waitForEvents = Priority.readFrom(in);
        }
        this.waitForNoInitializingShards = in.readBoolean();
        this.indicesOptions = in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_2_0) ? IndicesOptions.readIndicesOptions(in) : IndicesOptions.lenientExpandOpen();
        if (in.getVersion().onOrAfter(Version.V_2_5_0)) {
            this.awarenessAttribute = in.readOptionalString();
            this.level = (Level)in.readEnum(Level.class);
        }
        if (in.getVersion().onOrAfter(Version.V_2_6_0)) {
            this.ensureNodeWeighedIn = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.indices == null) {
            out.writeVInt(0);
        } else {
            out.writeStringArray(this.indices);
        }
        out.writeTimeValue(this.timeout);
        if (this.waitForStatus == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeByte(this.waitForStatus.value());
        }
        out.writeBoolean(this.waitForNoRelocatingShards);
        this.waitForActiveShards.writeTo(out);
        out.writeString(this.waitForNodes);
        if (this.waitForEvents == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Priority.writeTo(this.waitForEvents, out);
        }
        out.writeBoolean(this.waitForNoInitializingShards);
        if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_2_0)) {
            this.indicesOptions.writeIndicesOptions(out);
        }
        if (out.getVersion().onOrAfter(Version.V_2_5_0)) {
            out.writeOptionalString(this.awarenessAttribute);
            out.writeEnum((Enum)this.level);
        }
        if (out.getVersion().onOrAfter(Version.V_2_6_0)) {
            out.writeBoolean(this.ensureNodeWeighedIn);
        }
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public ClusterHealthRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public ClusterHealthRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public ClusterHealthRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        if (this.clusterManagerNodeTimeout == DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT) {
            this.clusterManagerNodeTimeout = timeout;
        }
        return this;
    }

    public ClusterHealthRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue((String)timeout, null, (String)(this.getClass().getSimpleName() + ".timeout")));
    }

    public ClusterHealthStatus waitForStatus() {
        return this.waitForStatus;
    }

    public ClusterHealthRequest waitForStatus(ClusterHealthStatus waitForStatus) {
        this.waitForStatus = waitForStatus;
        return this;
    }

    public ClusterHealthRequest waitForGreenStatus() {
        return this.waitForStatus(ClusterHealthStatus.GREEN);
    }

    public ClusterHealthRequest waitForYellowStatus() {
        return this.waitForStatus(ClusterHealthStatus.YELLOW);
    }

    public boolean waitForNoRelocatingShards() {
        return this.waitForNoRelocatingShards;
    }

    public ClusterHealthRequest waitForNoRelocatingShards(boolean waitForNoRelocatingShards) {
        this.waitForNoRelocatingShards = waitForNoRelocatingShards;
        return this;
    }

    public boolean waitForNoInitializingShards() {
        return this.waitForNoInitializingShards;
    }

    public ClusterHealthRequest waitForNoInitializingShards(boolean waitForNoInitializingShards) {
        this.waitForNoInitializingShards = waitForNoInitializingShards;
        return this;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public ClusterHealthRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards.equals(ActiveShardCount.DEFAULT) ? ActiveShardCount.NONE : waitForActiveShards;
        return this;
    }

    public ClusterHealthRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public String waitForNodes() {
        return this.waitForNodes;
    }

    public ClusterHealthRequest waitForNodes(String waitForNodes) {
        this.waitForNodes = waitForNodes;
        return this;
    }

    public ClusterHealthRequest waitForEvents(Priority waitForEvents) {
        this.waitForEvents = waitForEvents;
        return this;
    }

    public Priority waitForEvents() {
        return this.waitForEvents;
    }

    public void level(Level level) {
        this.level = Objects.requireNonNull(level, "level must not be null");
    }

    public void setLevel(String level) {
        switch (level) {
            case "indices": {
                this.level(Level.INDICES);
                break;
            }
            case "shards": {
                this.level(Level.SHARDS);
                break;
            }
            case "awareness_attributes": {
                this.level(Level.AWARENESS_ATTRIBUTES);
                break;
            }
            default: {
                this.level(Level.CLUSTER);
            }
        }
    }

    public Level level() {
        return this.level;
    }

    public ClusterHealthRequest setAwarenessAttribute(String awarenessAttribute) {
        this.awarenessAttribute = awarenessAttribute;
        return this;
    }

    public String getAwarenessAttribute() {
        return this.awarenessAttribute;
    }

    public final ClusterHealthRequest ensureNodeWeighedIn(boolean ensureNodeWeighedIn) {
        this.ensureNodeWeighedIn = ensureNodeWeighedIn;
        return this;
    }

    public final boolean ensureNodeWeighedIn() {
        return this.ensureNodeWeighedIn;
    }

    @Override
    public ActionRequestValidationException validate() {
        if (this.level.equals((Object)Level.AWARENESS_ATTRIBUTES) && this.indices.length > 0) {
            return ValidateActions.addValidationError("awareness_attribute is not a supported parameter with index health", null);
        }
        if (!this.level.equals((Object)Level.AWARENESS_ATTRIBUTES) && this.awarenessAttribute != null) {
            return ValidateActions.addValidationError("level=awareness_attributes is required with awareness_attribute parameter", null);
        }
        if (this.ensureNodeWeighedIn && !this.local) {
            return ValidateActions.addValidationError("not a local request to ensure local node commissioned or weighed in", null);
        }
        return null;
    }

    public static enum Level {
        CLUSTER,
        INDICES,
        SHARDS,
        AWARENESS_ATTRIBUTES;

    }
}

