# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from peertube.api_client import ApiClient
from peertube.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class FeedsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def feeds_video_comments_format_get(self, format, **kwargs):  # noqa: E501
        """List comments on videos  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.feeds_video_comments_format_get(format, async_req=True)
        >>> result = thread.get()

        :param format: format expected (we focus on making `rss` the most featureful ; it serves [Media RSS](https://www.rssboard.org/media-rss)) (required)
        :type format: str
        :param video_id: limit listing to a specific video
        :type video_id: str
        :param account_id: limit listing to a specific account
        :type account_id: str
        :param account_name: limit listing to a specific account
        :type account_name: str
        :param video_channel_id: limit listing to a specific video channel
        :type video_channel_id: str
        :param video_channel_name: limit listing to a specific video channel
        :type video_channel_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[object]
        """
        kwargs['_return_http_data_only'] = True
        return self.feeds_video_comments_format_get_with_http_info(format, **kwargs)  # noqa: E501

    def feeds_video_comments_format_get_with_http_info(self, format, **kwargs):  # noqa: E501
        """List comments on videos  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.feeds_video_comments_format_get_with_http_info(format, async_req=True)
        >>> result = thread.get()

        :param format: format expected (we focus on making `rss` the most featureful ; it serves [Media RSS](https://www.rssboard.org/media-rss)) (required)
        :type format: str
        :param video_id: limit listing to a specific video
        :type video_id: str
        :param account_id: limit listing to a specific account
        :type account_id: str
        :param account_name: limit listing to a specific account
        :type account_name: str
        :param video_channel_id: limit listing to a specific video channel
        :type video_channel_id: str
        :param video_channel_name: limit listing to a specific video channel
        :type video_channel_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[object], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_hosts = [
            'https://peertube2.cpy.re',
            'https://peertube3.cpy.re',
            'https://peertube.cpy.re'
        ]
        local_var_host = local_var_hosts[0]
        if kwargs.get('_host_index'):
            _host_index = int(kwargs.get('_host_index'))
            if _host_index < 0 or _host_index >= len(local_var_hosts):
                raise ApiValueError(
                    "Invalid host index. Must be 0 <= index < %s"
                    % len(local_var_host)
                )
            local_var_host = local_var_hosts[_host_index]
        local_var_params = locals()

        all_params = [
            'format',
            'video_id',
            'account_id',
            'account_name',
            'video_channel_id',
            'video_channel_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params and key != "_host_index":
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feeds_video_comments_format_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'format' is set
        if self.api_client.client_side_validation and ('format' not in local_var_params or  # noqa: E501
                                                        local_var_params['format'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `format` when calling `feeds_video_comments_format_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'format' in local_var_params:
            path_params['format'] = local_var_params['format']  # noqa: E501

        query_params = []
        if 'video_id' in local_var_params and local_var_params['video_id'] is not None:  # noqa: E501
            query_params.append(('videoId', local_var_params['video_id']))  # noqa: E501
        if 'account_id' in local_var_params and local_var_params['account_id'] is not None:  # noqa: E501
            query_params.append(('accountId', local_var_params['account_id']))  # noqa: E501
        if 'account_name' in local_var_params and local_var_params['account_name'] is not None:  # noqa: E501
            query_params.append(('accountName', local_var_params['account_name']))  # noqa: E501
        if 'video_channel_id' in local_var_params and local_var_params['video_channel_id'] is not None:  # noqa: E501
            query_params.append(('videoChannelId', local_var_params['video_channel_id']))  # noqa: E501
        if 'video_channel_name' in local_var_params and local_var_params['video_channel_name'] is not None:  # noqa: E501
            query_params.append(('videoChannelName', local_var_params['video_channel_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/xml', 'application/rss+xml', 'text/xml', 'application/atom+xml', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/feeds/video-comments.{format}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[object]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            _host=local_var_host,
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def feeds_videos_format_get(self, format, **kwargs):  # noqa: E501
        """List videos  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.feeds_videos_format_get(format, async_req=True)
        >>> result = thread.get()

        :param format: format expected (we focus on making `rss` the most featureful ; it serves [Media RSS](https://www.rssboard.org/media-rss)) (required)
        :type format: str
        :param account_id: limit listing to a specific account
        :type account_id: str
        :param account_name: limit listing to a specific account
        :type account_name: str
        :param video_channel_id: limit listing to a specific video channel
        :type video_channel_id: str
        :param video_channel_name: limit listing to a specific video channel
        :type video_channel_name: str
        :param sort: Sort column
        :type sort: str
        :param nsfw: whether to include nsfw videos, if any
        :type nsfw: str
        :param filter: Special filters which might require special rights:  * `local` - only videos local to the instance  * `all-local` - only videos local to the instance, but showing private and unlisted videos (requires Admin privileges)  * `all` - all videos, showing private and unlisted videos (requires Admin privileges) 
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[object]
        """
        kwargs['_return_http_data_only'] = True
        return self.feeds_videos_format_get_with_http_info(format, **kwargs)  # noqa: E501

    def feeds_videos_format_get_with_http_info(self, format, **kwargs):  # noqa: E501
        """List videos  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.feeds_videos_format_get_with_http_info(format, async_req=True)
        >>> result = thread.get()

        :param format: format expected (we focus on making `rss` the most featureful ; it serves [Media RSS](https://www.rssboard.org/media-rss)) (required)
        :type format: str
        :param account_id: limit listing to a specific account
        :type account_id: str
        :param account_name: limit listing to a specific account
        :type account_name: str
        :param video_channel_id: limit listing to a specific video channel
        :type video_channel_id: str
        :param video_channel_name: limit listing to a specific video channel
        :type video_channel_name: str
        :param sort: Sort column
        :type sort: str
        :param nsfw: whether to include nsfw videos, if any
        :type nsfw: str
        :param filter: Special filters which might require special rights:  * `local` - only videos local to the instance  * `all-local` - only videos local to the instance, but showing private and unlisted videos (requires Admin privileges)  * `all` - all videos, showing private and unlisted videos (requires Admin privileges) 
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[object], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_hosts = [
            'https://peertube2.cpy.re',
            'https://peertube3.cpy.re',
            'https://peertube.cpy.re'
        ]
        local_var_host = local_var_hosts[0]
        if kwargs.get('_host_index'):
            _host_index = int(kwargs.get('_host_index'))
            if _host_index < 0 or _host_index >= len(local_var_hosts):
                raise ApiValueError(
                    "Invalid host index. Must be 0 <= index < %s"
                    % len(local_var_host)
                )
            local_var_host = local_var_hosts[_host_index]
        local_var_params = locals()

        all_params = [
            'format',
            'account_id',
            'account_name',
            'video_channel_id',
            'video_channel_name',
            'sort',
            'nsfw',
            'filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params and key != "_host_index":
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feeds_videos_format_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'format' is set
        if self.api_client.client_side_validation and ('format' not in local_var_params or  # noqa: E501
                                                        local_var_params['format'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `format` when calling `feeds_videos_format_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'format' in local_var_params:
            path_params['format'] = local_var_params['format']  # noqa: E501

        query_params = []
        if 'account_id' in local_var_params and local_var_params['account_id'] is not None:  # noqa: E501
            query_params.append(('accountId', local_var_params['account_id']))  # noqa: E501
        if 'account_name' in local_var_params and local_var_params['account_name'] is not None:  # noqa: E501
            query_params.append(('accountName', local_var_params['account_name']))  # noqa: E501
        if 'video_channel_id' in local_var_params and local_var_params['video_channel_id'] is not None:  # noqa: E501
            query_params.append(('videoChannelId', local_var_params['video_channel_id']))  # noqa: E501
        if 'video_channel_name' in local_var_params and local_var_params['video_channel_name'] is not None:  # noqa: E501
            query_params.append(('videoChannelName', local_var_params['video_channel_name']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'nsfw' in local_var_params and local_var_params['nsfw'] is not None:  # noqa: E501
            query_params.append(('nsfw', local_var_params['nsfw']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/xml', 'application/rss+xml', 'text/xml', 'application/atom+xml', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/feeds/videos.{format}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[object]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            _host=local_var_host,
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
