/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.table;

import com.sun.jna.platform.win32.VersionHelpers;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import mediathek.config.MVConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class MVTable
extends JTable {
    private static final String FELDTRENNER = "|";
    private static final String SORT_ASCENDING = "ASCENDING";
    private static final String SORT_DESCENDING = "DESCENDING";
    private static final Logger logger = LogManager.getLogger();
    protected final int[] breite;
    protected final int[] reihe;
    public boolean useSmallSenderIcons;
    protected final int maxSpalten;
    private int[] selRows = new int[0];
    protected final boolean[] spaltenAnzeigen;
    protected final Optional<MVConfig.Configs> columnConfigurationDataConfigKey;
    protected final Optional<MVConfig.Configs> showIconsConfigKey;
    protected final Optional<MVConfig.Configs> smallSenderIconConfigKey;
    protected List<? extends RowSorter.SortKey> listeSortKeys;
    private boolean showSenderIcon;
    private boolean lineBreak = true;

    public MVTable(int maxColumns, boolean @NotNull [] visibleColumStore, @NotNull Optional<MVConfig.Configs> showIconsConfigKey, @NotNull Optional<MVConfig.Configs> smallSenderIconConfigKey, @NotNull Optional<MVConfig.Configs> columnConfigurationDataConfigKey) {
        this.maxSpalten = maxColumns;
        this.showIconsConfigKey = showIconsConfigKey;
        this.smallSenderIconConfigKey = smallSenderIconConfigKey;
        this.columnConfigurationDataConfigKey = columnConfigurationDataConfigKey;
        this.spaltenAnzeigen = visibleColumStore;
        Arrays.fill(this.spaltenAnzeigen, true);
        this.setAutoCreateRowSorter(true);
        this.setAutoResizeMode(0);
        this.breite = new int[this.maxSpalten];
        Arrays.fill(this.breite, -1);
        this.reihe = new int[this.maxSpalten];
        Arrays.fill(this.reihe, -1);
        showIconsConfigKey.ifPresent(key -> {
            this.showSenderIcon = Boolean.parseBoolean(MVConfig.get(key));
        });
        smallSenderIconConfigKey.ifPresent(key -> {
            this.useSmallSenderIcons = Boolean.parseBoolean(MVConfig.get(key));
        });
        this.calculateRowHeight();
        this.applyWindowsSevenTableEffects();
    }

    private void applyWindowsSevenTableEffects() {
        if (SystemUtils.IS_OS_WINDOWS && !VersionHelpers.IsWindows8OrGreater()) {
            this.setShowHorizontalLines(true);
            this.setShowVerticalLines(true);
        }
    }

    private RowSorter.SortKey sortKeyLesen(String s2, String strSortOrder) {
        RowSorter.SortKey sk;
        try {
            int column = Integer.parseInt(s2);
            SortOrder order = switch (strSortOrder) {
                case SORT_ASCENDING -> SortOrder.ASCENDING;
                case SORT_DESCENDING -> SortOrder.DESCENDING;
                default -> throw new IndexOutOfBoundsException("UNDEFINED SORT KEY");
            };
            sk = new RowSorter.SortKey(column, order);
        }
        catch (Exception ex) {
            return null;
        }
        return sk;
    }

    public boolean showSenderIcons() {
        return this.showSenderIcon;
    }

    public void setShowIcon(boolean newVal) {
        this.showSenderIcon = newVal;
    }

    public boolean isLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(boolean lb) {
        this.lineBreak = lb;
    }

    public void invertSelection() {
        ListSelectionModel mdl = this.getSelectionModel();
        int[] selected = this.getSelectedRows();
        mdl.setValueIsAdjusting(true);
        mdl.setSelectionInterval(0, this.getRowCount() - 1);
        for (int i : selected) {
            mdl.removeSelectionInterval(i, i);
        }
        mdl.setValueIsAdjusting(false);
    }

    private int getSizeArea() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int height = fm.getHeight();
        int sizeArea = this.lineBreak ? 4 * height : height;
        return sizeArea;
    }

    public void calculateRowHeight() {
        int sizeArea = this.getSizeArea();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int height = fm.getHeight() + 5;
        if (this.showSenderIcon) {
            if (this.useSmallSenderIcons) {
                if (height < 18) {
                    height = 20;
                }
            } else if (height < 30) {
                height = 36;
            }
        }
        this.setRowHeight(Math.max(height, sizeArea));
    }

    public void readColumnConfigurationData() {
        this.columnConfigurationDataConfigKey.ifPresent(key -> {
            try {
                String b = "";
                String r = "";
                String s2 = "";
                String upDown = "";
                boolean ok = false;
                String keyDataStr = MVConfig.get(key);
                if (!keyDataStr.isEmpty()) {
                    RowSorter.SortKey sk;
                    ok = true;
                    int f1 = keyDataStr.indexOf(FELDTRENNER);
                    if (f1 != -1) {
                        int f3;
                        b = keyDataStr.substring(0, f1);
                        int f2 = keyDataStr.indexOf(FELDTRENNER, f1 + 1);
                        if (f2 != -1) {
                            r = keyDataStr.substring(f1 + 1, f2);
                        }
                        if ((f3 = keyDataStr.indexOf(FELDTRENNER, f2 + 1)) != -1) {
                            s2 = keyDataStr.substring(f2 + 1, f3);
                            upDown = keyDataStr.substring(f3 + 1);
                        }
                    }
                    if (!this.arrLesen(b, this.breite)) {
                        ok = false;
                    }
                    if (!this.arrLesen(r, this.reihe)) {
                        ok = false;
                    }
                    if ((sk = this.sortKeyLesen(s2, upDown)) != null) {
                        ArrayList<RowSorter.SortKey> listSortKeys_ = new ArrayList<RowSorter.SortKey>();
                        listSortKeys_.add(sk);
                        this.getRowSorter().setSortKeys(listSortKeys_);
                    }
                }
                if (ok) {
                    this.setSpaltenEinAus(this.breite);
                    this.setSpalten();
                    this.calculateRowHeight();
                } else {
                    this.resetTabelle();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private boolean isColumnVisible(int index) {
        return this.spaltenAnzeigen[index];
    }

    protected void setSpaltenEinAus(int[] nr) {
        for (int i = 0; i < this.spaltenAnzeigen.length; ++i) {
            this.spaltenAnzeigen[i] = nr[i] > 0;
        }
    }

    public void fireTableDataChanged(boolean setSpalten) {
        if (setSpalten) {
            this.saveSelectedTableRows();
        }
        AbstractTableModel model = (AbstractTableModel)this.getModel();
        model.fireTableDataChanged();
        if (setSpalten) {
            this.restoreSelectedTableRows();
        }
    }

    public void scrollToSelection() {
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            int i = this.getSelectedRow();
            if (i == -1) {
                i = 0;
                this.getSelectionModel().setSelectionInterval(0, 0);
            }
            if (i >= rowCount) {
                i = rowCount - 1;
            }
            this.scrollToIndexDelegate(i);
        }
    }

    protected void scrollToIndexDelegate(int index) {
        this.scrollRectToVisible(this.getCellRect(index, 0, true));
    }

    protected void saveSelectedTableRows() {
        this.selRows = this.getSelectedRows();
    }

    protected void restoreSelectedTableRows() {
        if (this.selRows.length > 0) {
            int visibleRow;
            if (this.selRows.length == 1) {
                int selectedRow = this.selRows[0];
                this.selectionModel.setSelectionInterval(selectedRow, selectedRow);
                visibleRow = selectedRow;
            } else {
                this.selectionModel.setValueIsAdjusting(true);
                for (int selectedRow : this.selRows) {
                    if (selectedRow >= this.getRowCount()) continue;
                    this.addRowSelectionInterval(selectedRow, selectedRow);
                }
                this.selectionModel.setValueIsAdjusting(false);
                visibleRow = this.selRows[0];
            }
            this.scrollToIndexDelegate(visibleRow);
            this.requestFocus();
        }
    }

    protected void changeTableModelColumnWidths() {
        TableColumnModel model = this.getColumnModel();
        for (int i = 0; i < this.breite.length && i < this.getColumnCount(); ++i) {
            int colIndex = this.convertColumnIndexToView(i);
            TableColumn column = model.getColumn(colIndex);
            if (this.breite[i] == 0) {
                column.setMinWidth(0);
                column.setPreferredWidth(0);
                column.setMaxWidth(0);
                continue;
            }
            column.setMinWidth(10);
            column.setMaxWidth(3000);
            column.setPreferredWidth(this.breite[i]);
        }
    }

    protected void changeInternalColumnWidths() {
        for (int i = 0; i < this.breite.length && i < this.getColumnCount(); ++i) {
            if (!this.isColumnVisible(i)) {
                this.breite[i] = 0;
                continue;
            }
            if (this.breite[i] != 0) continue;
            this.breite[i] = 100;
        }
    }

    public void spaltenEinAus() {
        this.getSpalten();
        this.changeInternalColumnWidths();
        this.changeTableModelColumnWidths();
        this.validate();
    }

    public void getSpalten() {
        int i;
        this.saveSelectedTableRows();
        int columnCount = this.getModel().getColumnCount();
        for (i = 0; i < this.reihe.length && i < columnCount; ++i) {
            this.reihe[i] = this.convertColumnIndexToModel(i);
        }
        for (i = 0; i < this.breite.length && i < columnCount; ++i) {
            this.breite[i] = this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).getWidth();
        }
        this.listeSortKeys = this.getRowSorter() != null ? this.getRowSorter().getSortKeys() : null;
    }

    public void setSpalten() {
        try {
            this.changeInternalColumnWidths();
            TableColumnModel model = this.getColumnModel();
            this.changeTableModelColumnWidths();
            for (int i = 0; i < this.reihe.length && i < this.getColumnCount(); ++i) {
                model.moveColumn(this.convertColumnIndexToView(this.reihe[i]), i);
            }
            if (this.listeSortKeys != null && !this.listeSortKeys.isEmpty()) {
                this.getRowSorter().setSortKeys(this.listeSortKeys);
            }
            this.restoreSelectedTableRows();
            this.validate();
        }
        catch (Exception ex) {
            logger.error("setSpalten", (Throwable)ex);
        }
    }

    public void resetTabelle() {
        this.listeSortKeys = null;
        this.getRowSorter().setSortKeys(null);
        this.setRowSorter(null);
        this.setAutoCreateRowSorter(true);
        this.spaltenAusschalten();
        this.setSpaltenEinAus(this.breite);
        this.setSpalten();
        this.calculateRowHeight();
    }

    protected abstract void spaltenAusschalten();

    private String prepareTableConfigurationData() {
        int i;
        int[] reihe_ = new int[this.maxSpalten];
        int[] breite_ = new int[this.maxSpalten];
        for (int i2 = 0; i2 < reihe_.length && i2 < this.getModel().getColumnCount(); ++i2) {
            reihe_[i2] = this.convertColumnIndexToModel(i2);
        }
        TableColumnModel model = this.getColumnModel();
        for (i = 0; i < breite_.length && i < this.getModel().getColumnCount(); ++i) {
            breite_[i] = model.getColumn(this.convertColumnIndexToView(i)).getWidth();
        }
        StringBuilder b = new StringBuilder(Integer.toString(breite_[0]));
        StringBuilder r = new StringBuilder(Integer.toString(reihe_[0]));
        for (i = 1; i < this.breite.length; ++i) {
            b.append(',').append(breite_[i]);
            r.append(',').append(reihe_[i]);
        }
        this.listeSortKeys = this.getRowSorter().getSortKeys();
        String sortKeyColumnStr = "";
        String sortOrderStr = "";
        if (this.listeSortKeys != null && !this.listeSortKeys.isEmpty()) {
            RowSorter.SortKey sk = this.listeSortKeys.get(0);
            sortKeyColumnStr = String.valueOf(sk.getColumn());
            sortOrderStr = sk.getSortOrder() == SortOrder.ASCENDING ? SORT_ASCENDING : SORT_DESCENDING;
        }
        return String.valueOf(b) + FELDTRENNER + String.valueOf(r) + FELDTRENNER + sortKeyColumnStr + FELDTRENNER + sortOrderStr;
    }

    public void writeTableConfigurationData() {
        this.columnConfigurationDataConfigKey.ifPresent(key -> MVConfig.add(key, this.prepareTableConfigurationData()));
        this.showIconsConfigKey.ifPresent(key -> MVConfig.add(key, String.valueOf(this.showSenderIcon)));
        this.smallSenderIconConfigKey.ifPresent(key -> MVConfig.add(key, String.valueOf(this.useSmallSenderIcons)));
    }

    private boolean arrLesen(String s2, int[] arr) {
        if (this.maxSpalten != this.countNumberOfColumns(s2)) {
            return false;
        }
        for (int i = 0; i < this.maxSpalten; ++i) {
            String sub;
            if (s2.isEmpty()) continue;
            if (s2.contains(",")) {
                sub = s2.substring(0, s2.indexOf(44));
                s2 = s2.replaceFirst(sub + ",", "");
            } else {
                sub = s2;
                s2 = "";
            }
            try {
                arr[i] = Integer.parseInt(sub);
                continue;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    private int countNumberOfColumns(String s2) {
        return StringUtils.countMatches((CharSequence)s2, ',') + 1;
    }
}

