/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.HttpConnection;
import com.install4j.runtime.installer.helper.content.HttpRequestHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextRequestHandler
extends HttpRequestHandler {
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=(.*)");
    public static final Function<String, Boolean> DEFAULT_READ_CONTENT_TYPE = contentType -> contentType == null || contentType.startsWith("text/") || contentType.equals("application/json") || contentType.equals("application/javascript") || contentType.contains("charset");
    private Function<String, Boolean> readContentType = DEFAULT_READ_CONTENT_TYPE;

    public TextRequestHandler(Context context) {
        super(context);
    }

    public TextRequestHandler(int mode) {
        super(null, mode);
    }

    public TextResponse getTextResponse() throws IOException, UserCanceledException {
        return this.getTextResponse(false);
    }

    public TextResponse getTextResponse(boolean preventReadResponse) throws IOException, UserCanceledException {
        HttpConnection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        String response = null;
        String contentType = connection.getContentType();
        if (!preventReadResponse && this.isReadResponse()) {
            if (this.readContentType.apply(contentType).booleanValue()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                FileUtil.pumpStream(this.getUsedInputStream(), out, val -> !this.isCancelled());
                this.checkCancelled();
                response = out.toString(this.getCharset(contentType).name());
                if (Boolean.getBoolean("install4j.logTextResponse")) {
                    Logger.getInstance().log(null, "Text response: \"" + response, true);
                }
            } else {
                Logger.getInstance().log(null, "Content type \"" + contentType + "\" cannot be interpreted as text. Response body is not read.", false);
            }
        }
        return new TextResponse(response, connection.getResponseCode(), connection.getHeaderFields());
    }

    public void setReadContentType(Function<String, Boolean> readContentType) {
        this.readContentType = readContentType;
    }

    private void checkCancelled() throws UserCanceledException {
        if (this.isCancelled()) {
            Context context = this.getContext();
            ContextInt contextInt = ContextImpl.getContextInt(context);
            if (context != null && contextInt != null) {
                Logger.getInstance().info(contextInt.getEventSource(), "HTTP request was canceled by the user");
            }
            throw new UserCanceledException();
        }
    }

    private Charset getCharset(String contentType) {
        Matcher matcher;
        if (contentType != null && (matcher = CHARSET_PATTERN.matcher(contentType)).find()) {
            String charsetName = matcher.group(1);
            try {
                return Charset.forName(charsetName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return StandardCharsets.UTF_8;
    }

    @Override
    public TextRequestHandler connect(String urlString) throws IOException, UserCanceledException {
        return (TextRequestHandler)super.connect(urlString);
    }

    @Override
    public TextRequestHandler connect(String urlString, HttpRequestHandler.ConnectionPreparer connectionPreparer) throws IOException, UserCanceledException {
        return (TextRequestHandler)super.connect(urlString, connectionPreparer);
    }

    public static class TextResponse {
        private String text;
        private int responseCode;
        private Map<String, List<String>> headerFields;

        public TextResponse(String text, int responseCode, Map<String, List<String>> headerFields) {
            this.text = text;
            this.responseCode = responseCode;
            this.headerFields = headerFields;
        }

        public String getText() {
            return this.text;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public boolean isSuccess() {
            return this.getResponseCode() / 200 == 1;
        }

        public Map<String, List<String>> getHeaderFields() {
            return this.headerFields;
        }
    }
}

