/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaEnumConstantElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.EnumConstantElement;
import io.micronaut.inject.ast.EnumElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@Internal
class JavaEnumElement
extends JavaClassElement
implements EnumElement {
    protected List<EnumConstantElement> enumConstants;
    protected List<String> values;

    JavaEnumElement(TypeElement classElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        this(classElement, annotationMetadata, visitorContext, 0);
    }

    JavaEnumElement(TypeElement classElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext, int arrayDimensions) {
        super(classElement, annotationMetadata, visitorContext, Collections.emptyList(), Collections.emptyMap(), arrayDimensions, false);
    }

    public List<String> values() {
        if (this.values != null) {
            return this.values;
        }
        this.initEnum();
        return this.values;
    }

    public List<EnumConstantElement> elements() {
        if (this.enumConstants != null) {
            return this.enumConstants;
        }
        this.initEnum();
        return this.enumConstants;
    }

    private void initEnum() {
        this.values = new ArrayList<String>();
        this.enumConstants = new ArrayList<EnumConstantElement>();
        TypeElement nativeType = (TypeElement)this.getNativeType();
        for (Element element : nativeType.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            this.values.add(element.getSimpleName().toString());
            this.enumConstants.add(new JavaEnumConstantElement(this, (VariableElement)element, this.visitorContext.getAnnotationUtils().newAnnotationBuilder().build(element), this.visitorContext));
        }
        this.values = Collections.unmodifiableList(this.values);
        this.enumConstants = Collections.unmodifiableList(this.enumConstants);
    }

    @Override
    public ClassElement withArrayDimensions(int arrayDimensions) {
        return new JavaEnumElement(this.classElement, this.getAnnotationMetadata(), this.visitorContext, arrayDimensions);
    }
}

