/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.scala.internal;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.VersionInfo;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.Versioned;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.tasks.scala.ScalaCompileOptions;
import org.gradle.api.tasks.scala.internal.ScalaRuntimeHelper;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;

public class ScalaCompileOptionsConfigurer {
    private static final DefaultVersionComparator VERSION_COMPARATOR = new DefaultVersionComparator();

    public static void configure(ScalaCompileOptions scalaCompileOptions, JavaInstallationMetadata toolchain, Set<File> scalaClasspath, VersionParser versionParser) {
        if (toolchain == null) {
            return;
        }
        File scalaJar = ScalaRuntimeHelper.findScalaJar(scalaClasspath, "library");
        if (scalaJar == null) {
            return;
        }
        String scalaVersion = ScalaRuntimeHelper.getScalaVersion(scalaJar);
        if (scalaVersion == null) {
            return;
        }
        if (scalaCompileOptions.getAdditionalParameters() != null && scalaCompileOptions.getAdditionalParameters().stream().anyMatch(s -> s.startsWith("-target:"))) {
            return;
        }
        Integer jvmVersion = toolchain.getLanguageVersion().asInt();
        String targetParameter = ScalaCompileOptionsConfigurer.determineTargetParameter(scalaVersion, jvmVersion, versionParser);
        if (scalaCompileOptions.getAdditionalParameters() == null) {
            scalaCompileOptions.setAdditionalParameters(Collections.singletonList(targetParameter));
        } else {
            scalaCompileOptions.getAdditionalParameters().add(targetParameter);
        }
    }

    private static String determineTargetParameter(String scalaVersion, Integer jvmVersion, VersionParser versionParser) {
        VersionInfo currentScalaVersion = new VersionInfo(versionParser.transform(scalaVersion));
        int compareWith2131 = VERSION_COMPARATOR.compare((Versioned)currentScalaVersion, (Versioned)new VersionInfo(versionParser.transform("2.13.1")));
        if (compareWith2131 < 0) {
            return String.format("-target:jvm-1.%s", jvmVersion);
        }
        return String.format("-target:%s", jvmVersion);
    }
}

