/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.io.IOException;
import java.util.OptionalInt;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.FileZipInput;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Pair;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.internal.classpath.ClasspathFileTransformer;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.file.FileException;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.util.internal.GFileUtils;
import org.gradle.util.internal.JarUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InstrumentingClasspathFileTransformer
implements ClasspathFileTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstrumentingClasspathFileTransformer.class);
    private static final int CACHE_FORMAT = 5;
    private final FileLockManager fileLockManager;
    private final ClasspathWalker classpathWalker;
    private final ClasspathBuilder classpathBuilder;
    private final CachedClasspathTransformer.Transform transform;
    private final HashCode configHash;

    public InstrumentingClasspathFileTransformer(FileLockManager fileLockManager, ClasspathWalker classpathWalker, ClasspathBuilder classpathBuilder, CachedClasspathTransformer.Transform transform) {
        this.fileLockManager = fileLockManager;
        this.classpathWalker = classpathWalker;
        this.classpathBuilder = classpathBuilder;
        this.transform = transform;
        this.configHash = this.configHashFor(transform);
    }

    private HashCode configHashFor(CachedClasspathTransformer.Transform transform) {
        Hasher hasher = Hashing.defaultFunction().newHasher();
        hasher.putInt(5);
        hasher.putInt(22);
        transform.applyConfigurationTo(hasher);
        return hasher.hash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File transform(File source, FileSystemLocationSnapshot sourceSnapshot, File cacheDir) {
        String destDirName = this.hashOf(sourceSnapshot);
        File destDir = new File(cacheDir, destDirName);
        String destFileName = sourceSnapshot.getType() == FileType.Directory ? source.getName() + ".jar" : source.getName();
        File receipt = new File(destDir, destFileName + ".receipt");
        File transformed = new File(destDir, destFileName);
        if (receipt.isFile()) {
            return transformed;
        }
        File lockFile = new File(destDir, destFileName + ".lock");
        try (FileLock fileLock = this.exclusiveLockFor(lockFile);){
            if (receipt.isFile()) {
                File file = transformed;
                return file;
            }
            this.transform(source, transformed);
            try {
                receipt.createNewFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Failed to create receipt for instrumented classpath file '%s/%s'.", destDirName, destFileName), (Throwable)e);
            }
            File file = transformed;
            return file;
        }
    }

    private FileLock exclusiveLockFor(File file) {
        return this.fileLockManager.lock(file, (LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.Exclusive).useCrossVersionImplementation(), "instrumented jar cache");
    }

    private String hashOf(FileSystemLocationSnapshot sourceSnapshot) {
        Hasher hasher = Hashing.defaultFunction().newHasher();
        hasher.putHash(this.configHash);
        hasher.putHash(sourceSnapshot.getHash());
        return hasher.hash().toString();
    }

    private void transform(File source, File dest) {
        this.createTransformer(source).transform(dest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Transformation createTransformer(File source) {
        boolean bl;
        Boolean isMultiReleaseJar = null;
        if (source.isFile()) {
            try (ZipInput entries2 = FileZipInput.create((File)source);){
                for (ZipEntry entry : entries2) {
                    String entryName = entry.getName();
                    if (this.isJarSignatureFile(entryName)) {
                        SkipTransformation skipTransformation = new SkipTransformation(source);
                        return skipTransformation;
                    }
                    if (isMultiReleaseJar != null || !JarUtil.isManifestName(entryName)) continue;
                    isMultiReleaseJar = JarUtil.isMultiReleaseJarManifest(JarUtil.readManifest(entry.getContent()));
                }
            }
            catch (FileException entries2) {
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
        if (isMultiReleaseJar != null && isMultiReleaseJar.booleanValue()) {
            bl = true;
            return new InstrumentingTransformation(source, bl);
        }
        bl = false;
        return new InstrumentingTransformation(source, bl);
    }

    private boolean isJarSignatureFile(String entryName) {
        return entryName.startsWith("META-INF/") && entryName.endsWith(".SF");
    }

    private class InstrumentingTransformation
    implements Transformation {
        protected final File source;
        private final boolean isMultiReleaseJar;

        public InstrumentingTransformation(File source, boolean isMultiReleaseJar) {
            this.source = source;
            this.isMultiReleaseJar = isMultiReleaseJar;
        }

        @Override
        public final void transform(File destination) {
            InstrumentingClasspathFileTransformer.this.classpathBuilder.jar(destination, builder -> {
                try {
                    this.visitEntries(builder);
                }
                catch (FileException e) {
                    LOGGER.debug("Malformed archive '{}'. Discarding contents.", (Object)this.source.getName(), (Object)e);
                }
            });
        }

        private void visitEntries(ClasspathBuilder.EntryBuilder builder) throws IOException, FileException {
            InstrumentingClasspathFileTransformer.this.classpathWalker.visit(this.source, entry -> this.visitEntry(builder, entry));
        }

        private void visitEntry(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry entry) throws IOException {
            try {
                if (this.isClassFile(entry)) {
                    this.processClassFile(builder, entry);
                } else if (this.isManifest(entry)) {
                    this.processManifest(builder, entry);
                } else {
                    this.processResource(builder, entry);
                }
            }
            catch (Throwable e) {
                throw new IOException("Failed to process the entry '" + entry.getName() + "' from '" + this.source + "'", e);
            }
        }

        protected void processClassFile(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry classEntry) throws IOException {
            if (this.isMultiReleaseJar && this.isInUnsupportedMrJarVersionedDirectory(classEntry)) {
                return;
            }
            ClassReader reader = new ClassReader(classEntry.getContent());
            ClassWriter classWriter = new ClassWriter(1);
            Pair<RelativePath, ClassVisitor> chain = InstrumentingClasspathFileTransformer.this.transform.apply(classEntry, (ClassVisitor)classWriter);
            reader.accept((ClassVisitor)chain.right, 0);
            byte[] bytes = classWriter.toByteArray();
            builder.put(((RelativePath)chain.left).getPathString(), bytes, classEntry.getCompressionMethod());
        }

        protected void processManifest(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry manifestEntry) throws IOException {
            this.copyResource(builder, manifestEntry);
        }

        protected void processResource(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry resourceEntry) throws IOException {
            if (this.isMultiReleaseJar && this.isInUnsupportedMrJarVersionedDirectory(resourceEntry)) {
                return;
            }
            this.copyResource(builder, resourceEntry);
        }

        private void copyResource(ClasspathBuilder.EntryBuilder builder, ClasspathEntryVisitor.Entry resourceEntry) throws IOException {
            builder.put(resourceEntry.getName(), resourceEntry.getContent(), resourceEntry.getCompressionMethod());
        }

        private boolean isClassFile(ClasspathEntryVisitor.Entry entry) {
            return entry.getName().endsWith(".class");
        }

        private boolean isManifest(ClasspathEntryVisitor.Entry entry) {
            return JarUtil.isManifestName(entry.getName());
        }

        private boolean isInUnsupportedMrJarVersionedDirectory(ClasspathEntryVisitor.Entry entry) {
            OptionalInt version = JarUtil.getVersionedDirectoryMajorVersion(entry.getName());
            if (version.isPresent()) {
                return !this.isSupportedVersion(version.getAsInt());
            }
            return false;
        }

        private boolean isSupportedVersion(int javaMajorVersion) {
            return javaMajorVersion <= 22;
        }
    }

    private static class SkipTransformation
    implements Transformation {
        private final File source;

        public SkipTransformation(File source) {
            this.source = source;
        }

        @Override
        public void transform(File destination) {
            LOGGER.debug("Signed archive '{}'. Skipping instrumentation.", (Object)this.source.getName());
            GFileUtils.copyFile((File)this.source, (File)destination);
        }
    }

    private static interface Transformation {
        public void transform(File var1);
    }
}

