/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.tngtech.archunit.core.domain.Dependency;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.freeplane.plugin.codeexplorer.dependencies.DependencyRule;
import org.freeplane.plugin.codeexplorer.dependencies.DependencyVerdict;

public class DependencyJudge {
    private List<DependencyRule> rules;

    public DependencyJudge(List<DependencyRule> rules) {
        this.rules = rules;
    }

    public DependencyJudge() {
        this(Collections.emptyList());
    }

    public DependencyVerdict judge(Dependency dependency, boolean goesUp) {
        for (DependencyRule rule : this.rules) {
            Optional<DependencyVerdict> verdict = rule.match(dependency, goesUp);
            if (!verdict.isPresent()) continue;
            return verdict.get();
        }
        return goesUp ? DependencyVerdict.FORBIDDEN : DependencyVerdict.ALLOWED;
    }
}

