/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.bundlestorage.dex;

import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.bundlestorage.file.Archive;
import org.knopflerfish.framework.bundlestorage.file.BundleArchiveImpl;

public class DexArchive
extends Archive {
    private static final String CLASSES_DEX = "classes.dex";
    private static final String CLASS_SUFFIX = ".class";
    private DexFile dexFile = null;

    DexArchive(BundleArchiveImpl ba, FileTree dir, int rev) {
        super(ba, dir, rev);
    }

    @Override
    protected void downloadArchive(InputStream is, URL source) throws IOException {
        super.downloadArchive(is, source);
        this.initDexFile();
    }

    @Override
    protected void restoreArchive() throws IOException {
        super.restoreArchive();
        this.initDexFile();
    }

    @Override
    protected Archive subArchive(String path, int id) throws IOException {
        Archive res = super.subArchive(path, id);
        if (res.isJar()) {
            ((DexArchive)res).initDexFile();
        }
        return res;
    }

    @Override
    public boolean exists(String path, boolean onlyDirs) {
        if (path.endsWith(CLASS_SUFFIX) && !onlyDirs) {
            if (this.dexFile == null) {
                throw new RuntimeException("No classes.dex found for archive: " + this.file);
            }
            String name = path.substring(0, path.length() - CLASS_SUFFIX.length()).replace('/', '.');
            Enumeration e = this.dexFile.entries();
            while (e.hasMoreElements()) {
                String ee = (String)e.nextElement();
                if (!name.equals(ee)) continue;
                return true;
            }
            return false;
        }
        return super.exists(path, onlyDirs);
    }

    @Override
    public byte[] getClassBytes(String name) {
        return null;
    }

    @Override
    public Class<?> loadClassBytes(String name, ClassLoader cl) {
        return this.dexFile.loadClass(name.replace('.', '/'), cl);
    }

    private void initDexFile() {
        String dexopt = new File(this.bundleDir, "dexopt" + this.revision + (this.subId > 0 ? "_" + this.subId : "")).getAbsolutePath();
        if (this.jar != null) {
            if (this.jar.getEntry(CLASSES_DEX) != null) {
                this.dexFile = DexFile.loadDex((String)this.file.getAbsolutePath(), (String)dexopt, (int)0);
            }
        } else {
            this.dexFile = DexFile.loadDex((String)new File(this.file, CLASSES_DEX).getAbsolutePath(), (String)dexopt, (int)0);
        }
    }
}

